/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.util.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DispatchQueue {
    private Set<Invocation> subjectInvocations = new HashSet<Invocation>();
    private Map<Object, Collection<Invocation>> invocationsBySender = new WeakHashMap<Object, Collection<Invocation>>();

    DispatchQueue() {
    }

    synchronized void dispatchEvent(DefaultEventManager.Dispatch dispatch) {
        this.dispatchEvent(this.subjectInvocations, dispatch);
        Object sender = dispatch.getSender();
        this.dispatchEvent(this.invocationsForSender(sender, false), dispatch);
    }

    synchronized void addInvocation(Invocation invocation, Object sender) {
        Collection<Invocation> invocations = sender == null ? this.subjectInvocations : this.invocationsForSender(sender, true);
        Iterator it = invocations.iterator();
        while (it.hasNext()) {
            Invocation i = (Invocation)it.next();
            if (i.getTarget() != null) continue;
            it.remove();
        }
        invocations.add(invocation);
    }

    synchronized boolean removeInvocations(Object listener, Object sender) {
        if (sender != null) {
            return this.removeInvocations(this.invocationsForSender(sender, false), listener);
        }
        boolean didRemove = false;
        didRemove = this.removeInvocations(this.subjectInvocations, listener);
        for (Collection<Invocation> senderInvocations : this.invocationsBySender.values()) {
            if (senderInvocations == null) continue;
            Iterator<Invocation> it = senderInvocations.iterator();
            while (it.hasNext()) {
                Invocation invocation = it.next();
                if (invocation.getTarget() != listener) continue;
                it.remove();
                didRemove = true;
            }
        }
        return didRemove;
    }

    private Collection<Invocation> invocationsForSender(Object sender, boolean create) {
        Collection<Invocation> senderInvocations = this.invocationsBySender.get(sender);
        if (create && senderInvocations == null) {
            senderInvocations = new HashSet<Invocation>();
            this.invocationsBySender.put(sender, senderInvocations);
        }
        return senderInvocations;
    }

    private boolean removeInvocations(Collection<Invocation> invocations, Object listener) {
        if (invocations == null || invocations.isEmpty()) {
            return false;
        }
        boolean didRemove = false;
        Iterator<Invocation> invocationsIt = invocations.iterator();
        while (invocationsIt.hasNext()) {
            Invocation invocation = invocationsIt.next();
            if (invocation.getTarget() != listener) continue;
            invocationsIt.remove();
            didRemove = true;
        }
        return didRemove;
    }

    private void dispatchEvent(Collection<Invocation> invocations, DefaultEventManager.Dispatch dispatch) {
        if (invocations == null || invocations.isEmpty()) {
            return;
        }
        for (Invocation invocation : new ArrayList<Invocation>(invocations)) {
            if (dispatch.fire(invocation)) continue;
            invocations.remove(invocation);
        }
    }
}

