/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.io.Serializable;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.impl.SessionImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.SessionAwareAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public final class CmisBindingImpl
implements CmisBinding,
Serializable {
    private static final long serialVersionUID = 1L;
    private BindingSession session;
    private final BindingsObjectFactory objectFactory;
    private final RepositoryService repositoryServiceWrapper;

    public CmisBindingImpl(Map<String, String> sessionParameters) {
        this(sessionParameters, null, null);
    }

    public CmisBindingImpl(Map<String, String> sessionParameters, AuthenticationProvider authenticationProvider, TypeDefinitionCache typeDefCache) {
        String forceCmisVersion;
        String language;
        String authProviderClassName;
        if (sessionParameters == null) {
            throw new IllegalArgumentException("Session parameters must be set!");
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.spi.classname")) {
            throw new IllegalArgumentException("Session parameters do not contain a SPI class name!");
        }
        this.session = new SessionImpl();
        for (Map.Entry<String, String> entry : sessionParameters.entrySet()) {
            this.session.put(entry.getKey(), (Serializable)((Object)entry.getValue()));
        }
        if (authenticationProvider == null && (authProviderClassName = sessionParameters.get("org.apache.chemistry.opencmis.binding.auth.classname")) != null) {
            Object authProviderObj = null;
            try {
                authProviderObj = ClassLoaderUtil.loadClass((String)authProviderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not load authentication provider: " + e, e);
            }
            if (!(authProviderObj instanceof AuthenticationProvider)) {
                throw new IllegalArgumentException("Authentication provider does not implement AuthenticationProvider!");
            }
            authenticationProvider = authProviderObj;
        }
        if ((language = sessionParameters.get("org.apache.chemistry.opencmis.locale.iso639")) != null && (language = language.trim()).length() > 0) {
            String acceptLanguage;
            String country = sessionParameters.get("org.apache.chemistry.opencmis.locale.iso3166");
            if (country != null) {
                if ((country = country.trim()).length() > 0) {
                    country = "-" + country;
                }
            } else {
                country = "";
            }
            if ((acceptLanguage = language + country).indexOf(10) == -1 && acceptLanguage.indexOf(13) == -1) {
                this.session.put("org.apache.chemistry.opencmis.binding.acceptLanguage", (Serializable)((Object)acceptLanguage));
            }
        }
        if ((forceCmisVersion = sessionParameters.get("org.apache.chemistry.opencmis.cmisversion")) != null) {
            try {
                this.session.put("org.apache.chemistry.opencmis.cmisversion", (Serializable)CmisVersion.fromValue((String)forceCmisVersion));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid CMIS version value: " + forceCmisVersion, e);
            }
        }
        if (typeDefCache != null) {
            this.session.put("org.apache.chemistry.opencmis.binding.typeDefintionCache", typeDefCache);
            typeDefCache.initialize(this.session);
        }
        this.clearAllCaches();
        CmisBindingsHelper.getSPI(this.session);
        this.objectFactory = new BindingsObjectFactoryImpl();
        this.repositoryServiceWrapper = new RepositoryServiceImpl(this.session);
        if (authenticationProvider != null) {
            this.session.put("org.apache.chemistry.opencmis.binding.auth.object", (Serializable)authenticationProvider);
            if (authenticationProvider instanceof SessionAwareAuthenticationProvider) {
                ((SessionAwareAuthenticationProvider)authenticationProvider).setSession(this.session);
            }
        }
    }

    public String getSessionId() {
        return this.session.getSessionId();
    }

    public BindingType getBindingType() {
        Object bindingType = this.session.get("org.apache.chemistry.opencmis.binding.spi.type");
        if (!(bindingType instanceof String)) {
            return BindingType.CUSTOM;
        }
        try {
            return BindingType.fromValue((String)((String)bindingType));
        }
        catch (IllegalArgumentException e) {
            return BindingType.CUSTOM;
        }
    }

    public RepositoryService getRepositoryService() {
        this.checkSession();
        return this.repositoryServiceWrapper;
    }

    public NavigationService getNavigationService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getNavigationService();
    }

    public ObjectService getObjectService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getObjectService();
    }

    public DiscoveryService getDiscoveryService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getDiscoveryService();
    }

    public RelationshipService getRelationshipService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getRelationshipService();
    }

    public VersioningService getVersioningService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getVersioningService();
    }

    public AclService getAclService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getAclService();
    }

    public MultiFilingService getMultiFilingService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getMultiFilingService();
    }

    public PolicyService getPolicyService() {
        this.checkSession();
        CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
        return spi.getPolicyService();
    }

    public BindingsObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return CmisBindingsHelper.getAuthenticationProvider(this.session);
    }

    public void clearAllCaches() {
        this.checkSession();
        this.session.writeLock();
        try {
            this.session.put("org.apache.chemistry.opencmis.binding.repositoryInfoCache", new RepositoryInfoCache(this.session));
            TypeDefinitionCache typeDefCache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
            typeDefCache.removeAll();
            CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
            spi.clearAllCaches();
        }
        finally {
            this.session.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRepositoryCache(String repositoryId) {
        this.checkSession();
        if (repositoryId == null) {
            return;
        }
        this.session.writeLock();
        try {
            RepositoryInfoCache repInfoCache = (RepositoryInfoCache)this.session.get("org.apache.chemistry.opencmis.binding.repositoryInfoCache");
            repInfoCache.remove(repositoryId);
            TypeDefinitionCache typeDefCache = CmisBindingsHelper.getTypeDefinitionCache(this.session);
            typeDefCache.remove(repositoryId);
            CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
            spi.clearRepositoryCache(repositoryId);
        }
        finally {
            this.session.writeUnlock();
        }
    }

    public void close() {
        this.checkSession();
        this.session.writeLock();
        try {
            CmisSpi spi = CmisBindingsHelper.getSPI(this.session);
            spi.close();
        }
        finally {
            this.session.writeUnlock();
            this.session = null;
        }
    }

    private void checkSession() {
        if (this.session == null) {
            throw new IllegalStateException("Already closed.");
        }
    }
}

