/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.LinkAccess;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.RepositoryUrlCache;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisProxyAuthenticationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisServiceUnavailableException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisTooManyRequestsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoBrowserBindingImpl;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.parser.ContainerFactory;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public abstract class AbstractBrowserBindingService
implements LinkAccess {
    protected static final ContainerFactory SIMPLE_CONTAINER_FACTORY = new ContainerFactory(){

        public Map<String, Object> createObjectContainer() {
            return new LinkedHashMap<String, Object>();
        }

        public List<Object> creatArrayContainer() {
            return new ArrayList<Object>();
        }
    };
    private BindingSession session;
    private boolean succint;
    private DateTimeFormat dateTimeFormat;

    protected void setSession(BindingSession session) {
        this.session = session;
        Object succintObj = session.get("org.apache.chemistry.opencmis.binding.browser.succinct");
        this.succint = succintObj == null ? true : Boolean.parseBoolean(succintObj.toString());
        Object dateTimeFormatObj = session.get("org.apache.chemistry.opencmis.binding.browser.datetimeformat");
        this.dateTimeFormat = dateTimeFormatObj == null ? DateTimeFormat.SIMPLE : DateTimeFormat.fromValue((String)dateTimeFormatObj.toString().toLowerCase(Locale.ENGLISH));
    }

    protected BindingSession getSession() {
        return this.session;
    }

    protected HttpInvoker getHttpInvoker() {
        return CmisBindingsHelper.getHttpInvoker(this.session);
    }

    protected String getServiceUrl() {
        Object url = this.session.get("org.apache.chemistry.opencmis.binding.browser.url");
        if (url instanceof String) {
            return (String)url;
        }
        return null;
    }

    protected UrlBuilder getRepositoryUrl(String repositoryId, String selector) {
        UrlBuilder result = this.getRepositoryUrlCache().getRepositoryUrl(repositoryId, selector);
        if (result == null) {
            this.getRepositoriesInternal(repositoryId);
            result = this.getRepositoryUrlCache().getRepositoryUrl(repositoryId, selector);
        }
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        return result;
    }

    protected UrlBuilder getRepositoryUrl(String repositoryId) {
        UrlBuilder result = this.getRepositoryUrlCache().getRepositoryUrl(repositoryId);
        if (result == null) {
            this.getRepositoriesInternal(repositoryId);
            result = this.getRepositoryUrlCache().getRepositoryUrl(repositoryId);
        }
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        return result;
    }

    protected UrlBuilder getObjectUrl(String repositoryId, String objectId, String selector) {
        UrlBuilder result = this.getRepositoryUrlCache().getObjectUrl(repositoryId, objectId, selector);
        if (result == null) {
            this.getRepositoriesInternal(repositoryId);
            result = this.getRepositoryUrlCache().getObjectUrl(repositoryId, objectId, selector);
        }
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        return result;
    }

    protected UrlBuilder getObjectUrl(String repositoryId, String objectId) {
        UrlBuilder result = this.getRepositoryUrlCache().getObjectUrl(repositoryId, objectId);
        if (result == null) {
            this.getRepositoriesInternal(repositoryId);
            result = this.getRepositoryUrlCache().getObjectUrl(repositoryId, objectId);
        }
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        return result;
    }

    protected UrlBuilder getPathUrl(String repositoryId, String path, String selector) {
        UrlBuilder result = this.getRepositoryUrlCache().getPathUrl(repositoryId, path, selector);
        if (result == null) {
            this.getRepositoriesInternal(repositoryId);
            result = this.getRepositoryUrlCache().getPathUrl(repositoryId, path, selector);
        }
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        return result;
    }

    protected boolean getSuccinct() {
        return this.succint;
    }

    protected String getSuccinctParameter() {
        return this.succint ? "true" : null;
    }

    protected DateTimeFormat getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    protected String getDateTimeFormatParameter() {
        return this.dateTimeFormat == null || this.dateTimeFormat == DateTimeFormat.SIMPLE ? null : this.dateTimeFormat.value();
    }

    protected void setChangeToken(Holder<String> changeToken, ObjectData obj) {
        if (changeToken == null) {
            return;
        }
        changeToken.setValue(null);
        if (obj == null || obj.getProperties() == null || obj.getProperties().getProperties() == null) {
            return;
        }
        PropertyData ct = (PropertyData)obj.getProperties().getProperties().get("cmis:changeToken");
        if (ct instanceof PropertyString) {
            changeToken.setValue((Object)((String)((PropertyString)ct).getFirstValue()));
        }
    }

    protected CmisBaseException convertStatusCode(int code, String message, String errorContent, Throwable t) {
        JSONObject json;
        Object jsonError;
        Object obj = null;
        try {
            if (errorContent != null) {
                JSONParser parser = new JSONParser();
                obj = parser.parse(errorContent);
            }
        }
        catch (JSONParseException parser) {
            // empty catch block
        }
        if (obj instanceof JSONObject && (jsonError = (json = (JSONObject)obj).get((Object)"exception")) instanceof String) {
            Object jsonMessage = json.get((Object)"message");
            if (jsonMessage != null) {
                message = jsonMessage.toString();
            }
            HashMap<String, String> additionalData = null;
            for (Map.Entry e : json.entrySet()) {
                if ("exception".equalsIgnoreCase((String)e.getKey()) || "message".equalsIgnoreCase((String)e.getKey())) continue;
                if (additionalData == null) {
                    additionalData = new HashMap<String, String>();
                }
                additionalData.put((String)e.getKey(), e.getValue() == null ? null : e.getValue().toString());
            }
            if ("constraint".equalsIgnoreCase((String)jsonError)) {
                return new CmisConstraintException(message, errorContent, additionalData, t);
            }
            if ("contentAlreadyExists".equalsIgnoreCase((String)jsonError)) {
                return new CmisContentAlreadyExistsException(message, errorContent, additionalData, t);
            }
            if ("filterNotValid".equalsIgnoreCase((String)jsonError)) {
                return new CmisFilterNotValidException(message, errorContent, additionalData, t);
            }
            if ("invalidArgument".equalsIgnoreCase((String)jsonError)) {
                return new CmisInvalidArgumentException(message, errorContent, additionalData, t);
            }
            if ("nameConstraintViolation".equalsIgnoreCase((String)jsonError)) {
                return new CmisNameConstraintViolationException(message, errorContent, additionalData, t);
            }
            if ("notSupported".equalsIgnoreCase((String)jsonError)) {
                return new CmisNotSupportedException(message, errorContent, additionalData, t);
            }
            if ("objectNotFound".equalsIgnoreCase((String)jsonError)) {
                return new CmisObjectNotFoundException(message, errorContent, additionalData, t);
            }
            if ("permissionDenied".equalsIgnoreCase((String)jsonError)) {
                return new CmisPermissionDeniedException(message, errorContent, additionalData, t);
            }
            if ("storage".equalsIgnoreCase((String)jsonError)) {
                return new CmisStorageException(message, errorContent, additionalData, t);
            }
            if ("streamNotSupported".equalsIgnoreCase((String)jsonError)) {
                return new CmisStreamNotSupportedException(message, errorContent, additionalData, t);
            }
            if ("updateConflict".equalsIgnoreCase((String)jsonError)) {
                return new CmisUpdateConflictException(message, errorContent, additionalData, t);
            }
            if ("versioning".equalsIgnoreCase((String)jsonError)) {
                return new CmisVersioningException(message, errorContent, additionalData, t);
            }
            if (code == 503) {
                return new CmisServiceUnavailableException(message, errorContent, additionalData, t);
            }
        }
        switch (code) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return new CmisConnectionException("Redirects are not supported (HTTP status code " + code + "): " + message, errorContent, t);
            }
            case 400: {
                return new CmisInvalidArgumentException(message, errorContent, t);
            }
            case 401: {
                return new CmisUnauthorizedException(message, errorContent, t);
            }
            case 403: {
                return new CmisPermissionDeniedException(message, errorContent, t);
            }
            case 404: {
                return new CmisObjectNotFoundException(message, errorContent, t);
            }
            case 405: {
                return new CmisNotSupportedException(message, errorContent, t);
            }
            case 407: {
                return new CmisProxyAuthenticationException(message, errorContent, t);
            }
            case 409: {
                return new CmisConstraintException(message, errorContent, t);
            }
            case 429: {
                return new CmisTooManyRequestsException(message, errorContent, t);
            }
            case 503: {
                return new CmisServiceUnavailableException(message, errorContent, t);
            }
        }
        return new CmisRuntimeException(message, errorContent, t);
    }

    protected Map<String, Object> parseObject(InputStream stream, String charset) {
        Object obj = this.parse(stream, charset, SIMPLE_CONTAINER_FACTORY);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        throw new CmisConnectionException("Unexpected object!");
    }

    protected List<Object> parseArray(InputStream stream, String charset) {
        Object obj = this.parse(stream, charset, SIMPLE_CONTAINER_FACTORY);
        if (obj instanceof List) {
            return (List)obj;
        }
        throw new CmisConnectionException("Unexpected object!");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object parse(InputStream stream, String charset, ContainerFactory containerFactory) {
        InputStreamReader reader = null;
        Object obj = null;
        try {
            reader = new InputStreamReader(stream, charset);
            JSONParser parser = new JSONParser();
            obj = parser.parse((Reader)reader, containerFactory);
        }
        catch (JSONParseException e) {
            try {
                throw new CmisConnectionException("Parsing exception: " + e.getMessage(), (Throwable)e);
                catch (Exception e2) {
                    throw new CmisConnectionException("Parsing exception!", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.consumeAndClose(reader);
                if (reader != null) throw throwable;
                IOUtils.closeQuietly((Closeable)stream);
                throw throwable;
            }
        }
        IOUtils.consumeAndClose((Reader)reader);
        if (reader != null) return obj;
        IOUtils.closeQuietly((Closeable)stream);
        return obj;
    }

    protected Response read(UrlBuilder url) {
        Response resp = this.getHttpInvoker().invokeGET(url, this.session);
        if (resp.getResponseCode() != 200) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected Response post(UrlBuilder url, String contentType, Output writer) {
        Response resp = this.getHttpInvoker().invokePOST(url, contentType, writer, this.session);
        if (resp.getResponseCode() != 200 && resp.getResponseCode() != 201) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected void postAndConsume(UrlBuilder url, String contentType, Output writer) {
        Response resp = this.post(url, contentType, writer);
        IOUtils.consumeAndClose((InputStream)resp.getStream());
    }

    protected RepositoryUrlCache getRepositoryUrlCache() {
        RepositoryUrlCache repositoryUrlCache = (RepositoryUrlCache)this.getSession().get("org.apache.chemistry.opencmis.binding.browser.repositoryurls");
        if (repositoryUrlCache == null) {
            repositoryUrlCache = new RepositoryUrlCache();
            this.getSession().put("org.apache.chemistry.opencmis.binding.browser.repositoryurls", repositoryUrlCache);
        }
        return repositoryUrlCache;
    }

    protected List<RepositoryInfo> getRepositoriesInternal(String repositoryId) {
        UrlBuilder url = null;
        if (repositoryId == null) {
            url = new UrlBuilder(this.getServiceUrl());
        } else {
            url = this.getRepositoryUrlCache().getRepositoryUrl(repositoryId, "repositoryInfo");
            if (url == null) {
                url = new UrlBuilder(this.getServiceUrl());
            }
        }
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ArrayList<RepositoryInfo> repInfos = new ArrayList<RepositoryInfo>();
        for (Object jri : json.values()) {
            if (jri instanceof Map) {
                RepositoryInfo ri = JSONConverter.convertRepositoryInfo((Map)((Map)jri));
                String id = ri.getId();
                if (ri instanceof RepositoryInfoBrowserBindingImpl) {
                    String repositoryUrl = ((RepositoryInfoBrowserBindingImpl)ri).getRepositoryUrl();
                    String rootUrl = ((RepositoryInfoBrowserBindingImpl)ri).getRootUrl();
                    if (id == null || repositoryUrl == null || rootUrl == null) {
                        throw new CmisConnectionException("Found invalid Repository Info! (id: " + id + ")");
                    }
                    this.getRepositoryUrlCache().addRepository(id, repositoryUrl, rootUrl);
                }
                repInfos.add(ri);
                continue;
            }
            throw new CmisConnectionException("Found invalid Repository Info!");
        }
        return repInfos;
    }

    protected TypeDefinition getTypeDefinitionInternal(String repositoryId, String typeId) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId, "typeDefinition");
        url.addParameter("typeId", (Object)typeId);
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertTypeDefinition(json);
    }

    @Override
    public String loadLink(String repositoryId, String objectId, String rel, String type) {
        return null;
    }

    @Override
    public String loadContentLink(String repositoryId, String documentId) {
        UrlBuilder result = this.getRepositoryUrlCache().getObjectUrl(repositoryId, documentId, "content");
        return result == null ? null : result.toString();
    }

    @Override
    public String loadRenditionContentLink(String repositoryId, String documentId, String streamId) {
        UrlBuilder result = this.getRepositoryUrlCache().getObjectUrl(repositoryId, documentId, "content");
        if (result != null) {
            result.addParameter("streamId", (Object)streamId);
            return result.toString();
        }
        return null;
    }
}

