/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import javax.xml.ws.spi.Provider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.CXFPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.VersioningServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.WebSpherePortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisWebServicesSpi
implements CmisSpi {
    public static final String JAXWS_IMPL_RI = "sunri";
    public static final String JAXWS_IMPL_JRE = "sunjre";
    public static final String JAXWS_IMPL_CXF = "cxf";
    public static final String JAXWS_IMPL_WEBSPHERE = "websphere";
    public static final String JAXWS_IMPL_AXIS2 = "axis2";
    private static final Logger LOG = LoggerFactory.getLogger(CmisWebServicesSpi.class);
    private final RepositoryService repositoryService;
    private final NavigationService navigationService;
    private final ObjectService objectService;
    private final VersioningService versioningService;
    private final DiscoveryService discoveryService;
    private final MultiFilingService multiFilingService;
    private final RelationshipService relationshipService;
    private final PolicyService policyService;
    private final AclService aclService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CmisWebServicesSpi(BindingSession session) {
        AbstractPortProvider portProvider;
        block20: {
            String portProviderClass;
            block21: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {}: Initializing Web Services SPI...", (Object)session.getSessionId());
                }
                portProvider = null;
                portProviderClass = (String)session.get("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname");
                if (portProviderClass != null) break block21;
                String jaxwsImpl = (String)session.get("org.apache.chemistry.opencmis.binding.webservices.jaxws.impl");
                if (jaxwsImpl == null) {
                    jaxwsImpl = System.getProperty("org.apache.chemistry.opencmis.binding.webservices.jaxws.impl");
                }
                if (jaxwsImpl == null) {
                    Provider provider = Provider.provider();
                    if (provider == null) {
                        throw new CmisRuntimeException("No JAX-WS implementation found!");
                    }
                    String providerPackage = provider.getClass().getPackage().getName();
                    if (providerPackage.startsWith("com.sun.xml.internal.ws.spi")) {
                        throw new CmisRuntimeException("JRE JAX-WS implementation not supported anymore. Please use Apache CXF.");
                    }
                    if (providerPackage.startsWith("com.sun.xml.ws.spi")) {
                        throw new CmisRuntimeException("JAX-WS RI not supported anymore. Please use Apache CXF.");
                    }
                    if (providerPackage.startsWith("org.apache.cxf.jaxws")) {
                        portProvider = new CXFPortProvider();
                        break block20;
                    } else {
                        if (providerPackage.startsWith("org.apache.axis2.jaxws.spi")) {
                            throw new CmisRuntimeException("Axis2 not supported anymore. Please use Apache CXF.");
                        }
                        throw new CmisRuntimeException("Could not detect JAX-WS implementation! Use session parameter org.apache.chemistry.opencmis.binding.webservices.jaxws.impl to specify one.");
                    }
                }
                if (JAXWS_IMPL_JRE.equals(jaxwsImpl)) {
                    throw new CmisRuntimeException("JRE JAX-WS implementation not supported anymore. Please use Apache CXF.");
                }
                if (JAXWS_IMPL_RI.equals(jaxwsImpl)) {
                    throw new CmisRuntimeException("JAX-WS RI not supported anymore. Please use Apache CXF.");
                }
                if (JAXWS_IMPL_CXF.equals(jaxwsImpl)) {
                    portProvider = new CXFPortProvider();
                    break block20;
                } else if (JAXWS_IMPL_WEBSPHERE.equals(jaxwsImpl)) {
                    portProvider = new WebSpherePortProvider();
                    break block20;
                } else {
                    if (JAXWS_IMPL_AXIS2.equals(jaxwsImpl)) {
                        throw new CmisRuntimeException("Axis2 not supported anymore. Please use Apache CXF.");
                    }
                    throw new CmisRuntimeException("Unknown JAX-WS implementation specified!");
                }
            }
            Object portProviderObj = null;
            try {
                portProviderObj = ClassLoaderUtil.loadClass((String)portProviderClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not load port provider: " + e, e);
            }
            if (!(portProviderObj instanceof AbstractPortProvider)) {
                throw new IllegalArgumentException("Port provider does not implement AbstractPortProvider!");
            }
            portProvider = portProviderObj;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Port provider class: {}", (Object)session.getSessionId(), (Object)portProvider.getClass().getName());
        }
        portProvider.setSession(session);
        this.repositoryService = new RepositoryServiceImpl(session, portProvider);
        this.navigationService = new NavigationServiceImpl(session, portProvider);
        this.objectService = new ObjectServiceImpl(session, portProvider);
        this.versioningService = new VersioningServiceImpl(session, portProvider);
        this.discoveryService = new DiscoveryServiceImpl(session, portProvider);
        this.multiFilingService = new MultiFilingServiceImpl(session, portProvider);
        this.relationshipService = new RelationshipServiceImpl(session, portProvider);
        this.policyService = new PolicyServiceImpl(session, portProvider);
        this.aclService = new AclServiceImpl(session, portProvider);
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    @Override
    public ObjectService getObjectService() {
        return this.objectService;
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    @Override
    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    @Override
    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    @Override
    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    @Override
    public PolicyService getPolicyService() {
        return this.policyService;
    }

    @Override
    public AclService getAclService() {
        return this.aclService;
    }

    @Override
    public void clearAllCaches() {
    }

    @Override
    public void clearRepositoryCache(String repositoryId) {
    }

    @Override
    public void close() {
    }
}

