/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.endpoints;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.endpoints.CmisAuthentication;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpoint;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpointsDocument;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisAuthenticationImpl;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisEndpointImpl;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisEndpointsDocumentImpl;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;

public class CmisEndpointsDocumentHelper {
    public static CmisEndpointsDocument read(URL url) throws IOException, JSONParseException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null!");
        }
        InputStream stream = url.openStream();
        try {
            CmisEndpointsDocument cmisEndpointsDocument = CmisEndpointsDocumentHelper.read(stream);
            return cmisEndpointsDocument;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public static CmisEndpointsDocument read(File file) throws IOException, JSONParseException {
        if (file == null) {
            throw new IllegalArgumentException("File is null!");
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            CmisEndpointsDocument cmisEndpointsDocument = CmisEndpointsDocumentHelper.read(stream);
            return cmisEndpointsDocument;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public static CmisEndpointsDocument read(InputStream in) throws IOException, JSONParseException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream is null!");
        }
        return CmisEndpointsDocumentHelper.read(new InputStreamReader(in, "UTF-8"));
    }

    public static CmisEndpointsDocument read(Reader in) throws IOException, JSONParseException {
        if (in == null) {
            throw new IllegalArgumentException("Reader is null!");
        }
        JSONParser parser = new JSONParser();
        return CmisEndpointsDocumentHelper.convert(parser.parse(in));
    }

    public static CmisEndpointsDocument read(String in) throws JSONParseException {
        if (in == null) {
            throw new IllegalArgumentException("String is null!");
        }
        JSONParser parser = new JSONParser();
        return CmisEndpointsDocumentHelper.convert(parser.parse(in));
    }

    private static CmisEndpointsDocument convert(Object obj) throws JSONParseException {
        if (!(obj instanceof JSONObject)) {
            throw new IllegalArgumentException("JSON is not a CMIS Endpoint Document!");
        }
        return CmisEndpointsDocumentHelper.convertEndpointsDocument((JSONObject)obj);
    }

    private static CmisEndpointsDocument convertEndpointsDocument(JSONObject json) {
        CmisEndpointsDocumentImpl result = new CmisEndpointsDocumentImpl();
        for (Map.Entry entry : json.entrySet()) {
            if ("endpoints".equals(entry.getKey()) && entry.getValue() instanceof JSONArray) {
                result.put((String)entry.getKey(), CmisEndpointsDocumentHelper.convertEndpoints((JSONArray)entry.getValue()));
                continue;
            }
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static List<Object> convertEndpoints(JSONArray json) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : json) {
            if (item instanceof JSONObject) {
                CmisEndpointImpl endpoint = new CmisEndpointImpl();
                for (Map.Entry entry : ((JSONObject)item).entrySet()) {
                    if ("authentication".equals(entry.getKey()) && entry.getValue() instanceof JSONArray) {
                        endpoint.put((String)entry.getKey(), CmisEndpointsDocumentHelper.convertAuthentication(endpoint, (JSONArray)entry.getValue()));
                        continue;
                    }
                    endpoint.put((String)entry.getKey(), entry.getValue());
                }
                result.add(endpoint);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private static List<Object> convertAuthentication(CmisEndpoint endpoint, JSONArray json) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : json) {
            if (item instanceof JSONObject) {
                CmisAuthenticationImpl auth = new CmisAuthenticationImpl(endpoint);
                auth.putAll((JSONObject)item);
                result.add(auth);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public static void write(CmisEndpointsDocument doc, OutputStream out) throws IOException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must be set!");
        }
        if (out == null) {
            throw new IllegalArgumentException("OutputStream is null!");
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        CmisEndpointsDocumentHelper.write(doc, (Writer)writer);
        ((Writer)writer).flush();
    }

    public static void write(CmisEndpointsDocument doc, Writer out) throws IOException {
        if (doc == null) {
            throw new IllegalArgumentException("Document must be set!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Writer is null!");
        }
        JSONObject.writeJSONString((Map<String, Object>)doc, out);
        out.flush();
    }

    public static String write(CmisEndpointsDocument doc) {
        if (doc == null) {
            throw new IllegalArgumentException("Document must be set!");
        }
        return JSONObject.toJSONString((Map<String, Object>)doc);
    }

    public static void write(CmisEndpoint endpoint, OutputStream out) throws IOException {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must be set!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Endpoint is null!");
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        CmisEndpointsDocumentHelper.write(endpoint, (Writer)writer);
        ((Writer)writer).flush();
    }

    public static void write(CmisEndpoint endpoint, Writer out) throws IOException {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must be set!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Writer is null!");
        }
        JSONObject.writeJSONString((Map<String, Object>)endpoint, out);
        out.flush();
    }

    public static String write(CmisEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must be set!");
        }
        return JSONObject.toJSONString((Map<String, Object>)endpoint);
    }

    public static void write(CmisAuthentication authentication, OutputStream out) throws IOException {
        if (authentication == null) {
            throw new IllegalArgumentException("Authentication must be set!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Endpoint is null!");
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        CmisEndpointsDocumentHelper.write(authentication, (Writer)writer);
        ((Writer)writer).flush();
    }

    public static void write(CmisAuthentication authentication, Writer out) throws IOException {
        if (authentication == null) {
            throw new IllegalArgumentException("Authentication must be set!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Writer is null!");
        }
        JSONObject.writeJSONString((Map<String, Object>)authentication, out);
        out.flush();
    }

    public static String write(CmisAuthentication authentication) {
        if (authentication == null) {
            throw new IllegalArgumentException("Authentication must be set!");
        }
        return JSONObject.toJSONString((Map<String, Object>)authentication);
    }
}

