/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import com.sun.xml.ws.developer.StreamingAttachment;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

@MTOM
@StreamingAttachment(parseEagerly=false, memoryThreshold=0x4B4000L)
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort")
public class VersioningService
extends AbstractService
implements VersioningServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void cancelCheckOut(String repositoryId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.cancelCheckOut(repositoryId, objectId, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, CmisPropertiesType properties, CmisContentStreamType contentStream, String checkinComment, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.checkIn(repositoryId, objectIdHolder, major, WSConverter.convert((CmisPropertiesType)properties), WSConverter.convert((CmisContentStreamType)contentStream, (boolean)false), checkinComment, policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            WSConverter.closeStream((CmisContentStreamType)contentStream);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, Holder<CmisExtensionType> extension, Holder<Boolean> contentCopied) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder contentCopiedHolder;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                contentCopiedHolder = new org.apache.chemistry.opencmis.commons.spi.Holder();
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            service.checkOut(repositoryId, objectIdHolder, extData, contentCopiedHolder);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (contentCopied != null) {
                contentCopied.value = contentCopiedHolder.getValue();
            }
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public List<CmisObjectType> getAllVersions(String repositoryId, String versionSeriesId, String filter, Boolean includeAllowableActions, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectType> arrayList;
        List versions;
        CmisVersion cmisVersion;
        CmisService service;
        block10: {
            block9: {
                block8: {
                    service = null;
                    cmisVersion = null;
                    service = this.getService(this.wsContext, repositoryId);
                    cmisVersion = this.getCmisVersion(this.wsContext);
                    if (!this.stopBeforeService(service)) break block8;
                    List<CmisObjectType> list = null;
                    this.closeService(service);
                    return list;
                }
                versions = service.getAllVersions(repositoryId, null, versionSeriesId, filter, includeAllowableActions, WSConverter.convert((CmisExtensionType)extension));
                if (!this.stopAfterService(service)) break block9;
                List<CmisObjectType> list = null;
                this.closeService(service);
                return list;
            }
            if (versions != null) break block10;
            List<CmisObjectType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisObjectType> result = new ArrayList<CmisObjectType>();
            for (ObjectData object : versions) {
                result.add(WSConverter.convert((ObjectData)object, (CmisVersion)cmisVersion));
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisObjectType getObjectOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        ObjectData serviceResult;
        CmisVersion cmisVersion;
        CmisService service;
        block7: {
            block6: {
                service = null;
                cmisVersion = null;
                service = this.getService(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                if (!this.stopBeforeService(service)) break block6;
                CmisObjectType cmisObjectType2 = null;
                this.closeService(service);
                return cmisObjectType2;
            }
            serviceResult = service.getObjectOfLatestVersion(repositoryId, null, versionSeriesId, major, filter, includeAllowableActions, (IncludeRelationships)WSConverter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisObjectType cmisObjectType3 = null;
            this.closeService(service);
            return cmisObjectType3;
        }
        try {
            cmisObjectType = WSConverter.convert((ObjectData)serviceResult, (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisPropertiesType getPropertiesOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String filter, CmisExtensionType extension) throws CmisException {
        CmisPropertiesType cmisPropertiesType;
        Properties serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                CmisPropertiesType cmisPropertiesType2 = null;
                this.closeService(service);
                return cmisPropertiesType2;
            }
            serviceResult = service.getPropertiesOfLatestVersion(repositoryId, null, versionSeriesId, major, filter, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisPropertiesType cmisPropertiesType3 = null;
            this.closeService(service);
            return cmisPropertiesType3;
        }
        try {
            cmisPropertiesType = WSConverter.convert((Properties)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisPropertiesType;
    }
}

