/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Iterator;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

public class QueryPagingTest
extends AbstractQueryTest {
    private static final String CONTENT = "TCK test content.";
    private static final int NUM_DOCS = 20;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query Paging Test");
        this.setDescription("Performs IN_FOLDER queries with pages and checks if the page sizes are correct.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsQuery(session) && !this.isFulltextOnly(session)) {
            Folder testFolder = this.createTestFolder(session);
            try {
                for (int i = 0; i < 20; ++i) {
                    this.createDocument(session, testFolder, "doc" + i, CONTENT);
                }
                QueryStatement statement = session.createQueryStatement("SELECT ? FROM ? WHERE IN_FOLDER(?)");
                statement.setProperty(1, "cmis:document", "cmis:objectId");
                statement.setType(2, "cmis:document");
                statement.setString(3, new String[]{testFolder.getId()});
                ItemIterable iter1 = statement.query(false).skipTo(0L).getPage(5);
                int count1 = this.countResults((ItemIterable<QueryResult>)iter1);
                long total1 = iter1.getTotalNumItems();
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Repository returned more hits than requested for the first test page! (maxItems=5, returned=" + count1 + ")");
                this.addResult(this.assertIsTrue(count1 <= 5, null, f));
                f = this.createInfoResult("Repository did return fewer hits than requested for the first test page. (maxItems=5, returned=" + count1 + ")");
                this.addResult(this.assertIsTrue(count1 >= 5, null, f));
                if (total1 == -1L) {
                    this.addResult(this.createInfoResult("Repository did not return numItems for the first test page."));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Returned numItems doesn't match the number of documents!");
                    this.addResult(this.assertEquals(20L, total1, null, (CmisTestResult)f));
                }
                ItemIterable iter2 = statement.query(false).skipTo(5L).getPage(10);
                int count2 = this.countResults((ItemIterable<QueryResult>)iter2);
                long total2 = iter2.getTotalNumItems();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Repository returned more hits than requested for the second test page! (maxItems=10, returned=" + count2 + ")");
                this.addResult(this.assertIsTrue(count2 <= 10, null, f));
                f = this.createInfoResult("Repository did return fewer hits than requested for the second test page. (maxItems=5, returned=" + count2 + ")");
                this.addResult(this.assertIsTrue(count2 >= 10, null, f));
                if (total2 == -1L) {
                    this.addResult(this.createInfoResult("Repository did not return numItems for the second test page."));
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "Returned numItems doesn't match the number of documents!");
                this.addResult(this.assertEquals(20L, total2, null, (CmisTestResult)f));
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Metadata query not supported. Test Skipped!"));
        }
    }

    private int countResults(ItemIterable<QueryResult> iter) {
        int count = 0;
        Iterator iterator = iter.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

