/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.facade;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.mem.TrackingTripleIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.jena.commons.Jena2TriaUtil;
import org.apache.clerezza.rdf.jena.commons.Tria2JenaUtil;
import org.apache.clerezza.rdf.jena.facade.DirectReifier;
import org.wymiwyg.commons.util.collections.BidiMap;
import org.wymiwyg.commons.util.collections.BidiMapImpl;

public class JenaGraph
extends GraphBase
implements Graph {
    final TripleCollection graph;
    final BidiMap<BNode, Node> tria2JenaBNodes = new BidiMapImpl();
    final Jena2TriaUtil jena2TriaUtil = new Jena2TriaUtil((Map)this.tria2JenaBNodes.inverse());
    final Tria2JenaUtil tria2JenaUtil = new Tria2JenaUtil(this.tria2JenaBNodes);

    public JenaGraph(TripleCollection graph) {
        this.graph = graph;
    }

    public void performAdd(Triple triple) {
        this.graph.add((Object)this.jena2TriaUtil.convertTriple(triple));
    }

    public void performDelete(Triple triple) {
        org.apache.clerezza.rdf.core.Triple clerezzaTriple = this.jena2TriaUtil.convertTriple(triple);
        if (clerezzaTriple != null) {
            this.graph.remove((Object)clerezzaTriple);
        }
    }

    private Iterator<Triple> convert(final Iterator<org.apache.clerezza.rdf.core.Triple> base) {
        return new Iterator<Triple>(){
            org.apache.clerezza.rdf.core.Triple lastReturned = null;

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public Triple next() {
                org.apache.clerezza.rdf.core.Triple baseNext;
                this.lastReturned = baseNext = (org.apache.clerezza.rdf.core.Triple)base.next();
                return baseNext == null ? null : JenaGraph.this.tria2JenaUtil.convertTriple(baseNext, true);
            }

            @Override
            public void remove() {
                JenaGraph.this.graph.remove((Object)this.lastReturned);
            }
        };
    }

    private Iterator<org.apache.clerezza.rdf.core.Triple> filter(TripleMatch m) {
        NonLiteral subject = null;
        UriRef predicate = null;
        Resource object = null;
        if (m.getMatchSubject() != null && (subject = this.jena2TriaUtil.convertNonLiteral(m.getMatchSubject())) == null) {
            return Collections.EMPTY_SET.iterator();
        }
        if (m.getMatchObject() != null && (object = this.jena2TriaUtil.convertJenaNode2Resource(m.getMatchObject())) == null) {
            return Collections.EMPTY_SET.iterator();
        }
        if (m.getMatchPredicate() != null) {
            predicate = this.jena2TriaUtil.convertJenaUri2UriRef(m.getMatchPredicate());
        }
        try {
            return this.graph.filter(subject, predicate, object);
        }
        catch (IllegalArgumentException e) {
            return new HashSet().iterator();
        }
    }

    protected ExtendedIterator graphBaseFind(TripleMatch m) {
        return new TrackingTripleIterator(this.convert(this.filter(m)));
    }

    protected Reifier constructReifier() {
        return new DirectReifier(this);
    }
}

