/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorHsl {
    public static final ColorHsl BLACK = new ColorHsl(0.0, 0.0, 0.0);
    public static final ColorHsl WHITE = new ColorHsl(0.0, 0.0, 100.0);
    public static final ColorHsl RED = new ColorHsl(0.0, 100.0, 100.0);
    public static final ColorHsl GREEN = new ColorHsl(120.0, 100.0, 100.0);
    public static final ColorHsl BLUE = new ColorHsl(240.0, 100.0, 100.0);
    public final double h;
    public final double s;
    public final double l;

    public ColorHsl(double h, double s, double l) {
        this.h = h;
        this.s = s;
        this.l = l;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorHsl colorHsl = (ColorHsl)o;
        if (Double.compare(colorHsl.h, this.h) != 0) {
            return false;
        }
        if (Double.compare(colorHsl.l, this.l) != 0) {
            return false;
        }
        return Double.compare(colorHsl.s, this.s) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.h);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.s);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.l);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "{H: " + this.h + ", S: " + this.s + ", L: " + this.l + "}";
    }
}

