/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingConstants;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BigEndianBinaryOutputStream;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBlock;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypeLookup;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.internal.Debug;

public class IptcParser
extends BinaryFileParser {
    private static final Logger LOGGER = Logger.getLogger(IptcParser.class.getName());
    private static final ByteOrder APP13_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final List<Integer> PHOTOSHOP_IGNORED_BLOCK_TYPE = Arrays.asList(1084, 1085, 1086, 1087);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final int ENV_TAG_CODED_CHARACTER_SET = 90;
    private static final byte[] CHARACTER_ESCAPE_SEQUENCE = new byte[]{27, 37, 71};

    public IptcParser() {
        super(ByteOrder.BIG_ENDIAN);
    }

    private Charset findCharset(byte[] codedCharset) {
        String codedCharsetString = new String(codedCharset, StandardCharsets.ISO_8859_1);
        try {
            if (Charset.isSupported(codedCharsetString)) {
                return Charset.forName(codedCharsetString);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[] codedCharsetNormalized = Allocator.byteArray(codedCharset.length);
        int j = 0;
        for (byte element : codedCharset) {
            if (element == 32) continue;
            codedCharsetNormalized[j++] = element;
        }
        if (Objects.deepEquals(codedCharsetNormalized, CHARACTER_ESCAPE_SEQUENCE)) {
            return StandardCharsets.UTF_8;
        }
        return DEFAULT_CHARSET;
    }

    public boolean isPhotoshopJpegSegment(byte[] segmentData) {
        if (!BinaryFunctions.startsWith(segmentData, JpegConstants.PHOTOSHOP_IDENTIFICATION_STRING)) {
            return false;
        }
        int index = JpegConstants.PHOTOSHOP_IDENTIFICATION_STRING.size();
        return index + 4 <= segmentData.length && ByteConversions.toInt(segmentData, index, APP13_BYTE_ORDER) == JpegConstants.CONST_8BIM;
    }

    protected List<IptcBlock> parseAllBlocks(byte[] bytes, boolean strict) throws ImagingException, IOException {
        ArrayList<IptcBlock> blocks = new ArrayList<IptcBlock>();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            byte[] idString = BinaryFunctions.readBytes("", bis, JpegConstants.PHOTOSHOP_IDENTIFICATION_STRING.size(), "App13 Segment missing identification string");
            if (!JpegConstants.PHOTOSHOP_IDENTIFICATION_STRING.equals(idString)) {
                throw new ImagingException("Not a Photoshop App13 Segment");
            }
            while (true) {
                byte[] blockData;
                byte[] blockNameBytes;
                int imageResourceBlockSignature;
                try {
                    imageResourceBlockSignature = BinaryFunctions.read4Bytes("", bis, "Image Resource Block missing identification string", APP13_BYTE_ORDER);
                }
                catch (IOException ioEx) {
                    break;
                }
                if (imageResourceBlockSignature != JpegConstants.CONST_8BIM) {
                    throw new ImagingException("Invalid Image Resource Block Signature");
                }
                int blockType = BinaryFunctions.read2Bytes("", bis, "Image Resource Block missing type", APP13_BYTE_ORDER);
                Debug.debug("blockType: " + blockType + " (0x" + Integer.toHexString(blockType) + ")");
                if (PHOTOSHOP_IGNORED_BLOCK_TYPE.contains(blockType)) {
                    Debug.debug("Skipping blockType: " + blockType + " (0x" + Integer.toHexString(blockType) + ")");
                    BinaryFunctions.searchQuad(JpegConstants.CONST_8BIM, bis);
                    continue;
                }
                byte blockNameLength = BinaryFunctions.readByte("Name length", bis, "Image Resource Block missing name length");
                if (blockNameLength > 0) {
                    Debug.debug("blockNameLength: " + blockNameLength + " (0x" + Integer.toHexString(blockNameLength) + ")");
                }
                if (blockNameLength == 0) {
                    BinaryFunctions.readByte("Block name bytes", bis, "Image Resource Block has invalid name");
                    blockNameBytes = ImagingConstants.EMPTY_BYTE_ARRAY;
                } else {
                    try {
                        blockNameBytes = BinaryFunctions.readBytes("", bis, blockNameLength, "Invalid Image Resource Block name");
                    }
                    catch (IOException ioEx) {
                        if (!strict) break;
                        throw ioEx;
                    }
                    if (blockNameLength % 2 == 0) {
                        BinaryFunctions.readByte("Padding byte", bis, "Image Resource Block missing padding byte");
                    }
                }
                int blockSize = BinaryFunctions.read4Bytes("", bis, "Image Resource Block missing size", APP13_BYTE_ORDER);
                Debug.debug("blockSize: " + blockSize + " (0x" + Integer.toHexString(blockSize) + ")");
                if (blockSize > bytes.length) {
                    throw new ImagingException("Invalid Block Size : " + blockSize + " > " + bytes.length);
                }
                try {
                    blockData = BinaryFunctions.readBytes("", bis, blockSize, "Invalid Image Resource Block data");
                }
                catch (IOException ioEx) {
                    if (!strict) break;
                    throw ioEx;
                }
                blocks.add(new IptcBlock(blockType, blockNameBytes, blockData));
                if (blockSize % 2 == 0) continue;
                BinaryFunctions.readByte("Padding byte", bis, "Image Resource Block missing padding byte");
            }
            ArrayList<IptcBlock> arrayList = blocks;
            return arrayList;
        }
    }

    protected List<IptcRecord> parseIptcBlock(byte[] bytes) {
        Charset charset = DEFAULT_CHARSET;
        ArrayList<IptcRecord> elements = new ArrayList<IptcRecord>();
        int index = 0;
        while (index + 1 < bytes.length) {
            int tagMarker = 0xFF & bytes[index++];
            Debug.debug("tagMarker: " + tagMarker + " (0x" + Integer.toHexString(tagMarker) + ")");
            if (tagMarker != 28) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unexpected record tag marker in IPTC data.");
                }
                return elements;
            }
            int recordNumber = 0xFF & bytes[index++];
            Debug.debug("recordNumber: " + recordNumber + " (0x" + Integer.toHexString(recordNumber) + ")");
            int recordType = 0xFF & bytes[index];
            Debug.debug("recordType: " + recordType + " (0x" + Integer.toHexString(recordType) + ")");
            int recordSize = ByteConversions.toUInt16(bytes, ++index, this.getByteOrder());
            index += 2;
            boolean extendedDataset = recordSize > Short.MAX_VALUE;
            int dataFieldCountLength = recordSize & Short.MAX_VALUE;
            if (extendedDataset) {
                Debug.debug("extendedDataset. dataFieldCountLength: " + dataFieldCountLength);
            }
            if (extendedDataset) {
                return elements;
            }
            byte[] recordData = BinaryFunctions.slice(bytes, index, recordSize);
            index += recordSize;
            if (recordNumber == 1 && recordType == 90) {
                charset = this.findCharset(recordData);
                continue;
            }
            if (recordNumber != 2) continue;
            if (recordType == 0) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("ignore record version record! " + elements.size());
                continue;
            }
            String value = new String(recordData, charset);
            IptcType iptcType = IptcTypeLookup.getIptcType(recordType);
            IptcRecord element = new IptcRecord(iptcType, value);
            elements.add(element);
        }
        return elements;
    }

    public PhotoshopApp13Data parsePhotoshopSegment(byte[] bytes, boolean strict) throws ImagingException, IOException {
        ArrayList<IptcRecord> records = new ArrayList<IptcRecord>();
        List<IptcBlock> blocks = this.parseAllBlocks(bytes, strict);
        for (IptcBlock block : blocks) {
            if (!block.isIptcBlock()) continue;
            records.addAll(this.parseIptcBlock(block.getBlockData()));
        }
        return new PhotoshopApp13Data(records, blocks);
    }

    public PhotoshopApp13Data parsePhotoshopSegment(byte[] bytes, ImagingParameters<JpegImagingParameters> params) throws ImagingException, IOException {
        boolean strict = params != null && params.isStrict();
        return this.parsePhotoshopSegment(bytes, strict);
    }

    public byte[] writeIptcBlock(List<IptcRecord> elements) throws ImagingException, IOException {
        Charset charset = DEFAULT_CHARSET;
        for (IptcRecord element : elements) {
            byte[] recordData = element.getValue().getBytes(charset);
            if (new String(recordData, charset).equals(element.getValue())) continue;
            charset = StandardCharsets.UTF_8;
            break;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BinaryOutputStream bos = BinaryOutputStream.create(baos, this.getByteOrder());){
            if (!charset.equals(DEFAULT_CHARSET)) {
                bos.write(28);
                bos.write(1);
                bos.write(90);
                byte[] codedCharset = CHARACTER_ESCAPE_SEQUENCE;
                bos.write2Bytes(codedCharset.length);
                bos.write(codedCharset);
            }
            bos.write(28);
            bos.write(2);
            bos.write(IptcTypes.RECORD_VERSION.type);
            bos.write2Bytes(2);
            bos.write2Bytes(2);
            elements = new ArrayList<IptcRecord>(elements);
            Comparator comparator = (e1, e2) -> e2.iptcType.getType() - e1.iptcType.getType();
            elements.sort(comparator);
            for (IptcRecord element : elements) {
                if (element.iptcType == IptcTypes.RECORD_VERSION) continue;
                bos.write(28);
                bos.write(2);
                if (element.iptcType.getType() < 0 || element.iptcType.getType() > 255) {
                    throw new ImagingException("Invalid record type: " + element.iptcType.getType());
                }
                bos.write(element.iptcType.getType());
                byte[] recordData = element.getValue().getBytes(charset);
                bos.write2Bytes(recordData.length);
                bos.write(recordData);
            }
        }
        byte[] blockData = baos.toByteArray();
        return blockData;
    }

    public byte[] writePhotoshopApp13Segment(PhotoshopApp13Data data) throws IOException, ImagingException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Object object;
            block16: {
                BigEndianBinaryOutputStream bos = BinaryOutputStream.bigEndian(os);
                try {
                    JpegConstants.PHOTOSHOP_IDENTIFICATION_STRING.writeTo(bos);
                    List<IptcBlock> blocks = data.getRawBlocks();
                    for (IptcBlock block : blocks) {
                        byte[] blockData;
                        ((BinaryOutputStream)bos).write4Bytes(JpegConstants.CONST_8BIM);
                        if (block.getBlockType() < 0 || block.getBlockType() > 65535) {
                            throw new ImagingException("Invalid IPTC block type.");
                        }
                        ((BinaryOutputStream)bos).write2Bytes(block.getBlockType());
                        byte[] blockNameBytes = block.getBlockNameBytes();
                        if (blockNameBytes.length > 255) {
                            throw new ImagingException("IPTC block name is too long: " + blockNameBytes.length);
                        }
                        bos.write(blockNameBytes.length);
                        bos.write(blockNameBytes);
                        if (blockNameBytes.length % 2 == 0) {
                            bos.write(0);
                        }
                        if ((blockData = block.getBlockData()).length > Short.MAX_VALUE) {
                            throw new ImagingException("IPTC block data is too long: " + blockData.length);
                        }
                        ((BinaryOutputStream)bos).write4Bytes(blockData.length);
                        bos.write(blockData);
                        if (blockData.length % 2 != 1) continue;
                        bos.write(0);
                    }
                    bos.flush();
                    object = os.toByteArray();
                    if (bos == null) break block16;
                }
                catch (Throwable throwable) {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bos.close();
            }
            return object;
        }
    }
}

