/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;

public class TiffImagingParameters
extends XmpImagingParameters<TiffImagingParameters> {
    private boolean readThumbnails = true;
    private TiffOutputSet tiffOutputSet;
    private int subImageX;
    private int subImageY;
    private int subImageWidth;
    private int subImageHeight;
    private PhotometricInterpreter customPhotometricInterpreter;
    private Integer compression;
    private Integer lzwCompressionBlockSize;
    private Integer t4Options;
    private Integer t6Options;

    public void clearSubImage() {
        this.subImageWidth = 0;
        this.subImageHeight = 0;
    }

    public Integer getCompression() {
        return this.compression;
    }

    public PhotometricInterpreter getCustomPhotometricInterpreter() {
        return this.customPhotometricInterpreter;
    }

    public Integer getLzwCompressionBlockSize() {
        return this.lzwCompressionBlockSize;
    }

    public TiffOutputSet getOutputSet() {
        return this.tiffOutputSet;
    }

    public int getSubImageHeight() {
        return this.subImageHeight;
    }

    public int getSubImageWidth() {
        return this.subImageWidth;
    }

    public int getSubImageX() {
        return this.subImageX;
    }

    public int getSubImageY() {
        return this.subImageY;
    }

    public Integer getT4Options() {
        return this.t4Options;
    }

    public Integer getT6Options() {
        return this.t6Options;
    }

    public boolean isReadThumbnails() {
        return this.readThumbnails;
    }

    public boolean isSubImageSet() {
        return this.subImageWidth > 0 && this.subImageHeight > 0;
    }

    public TiffImagingParameters setCompression(Integer compression) {
        this.compression = compression;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setCustomPhotometricInterpreter(PhotometricInterpreter customPhotometricInterpreter) {
        this.customPhotometricInterpreter = customPhotometricInterpreter;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setLzwCompressionBlockSize(Integer lzwCompressionBlockSize) {
        this.lzwCompressionBlockSize = lzwCompressionBlockSize;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setOutputSet(TiffOutputSet tiffOutputSet) {
        this.tiffOutputSet = tiffOutputSet;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setReadThumbnails(boolean readThumbnails) {
        this.readThumbnails = readThumbnails;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setSubImage(int x, int y, int width, int height) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Invalid sub-image specification: negative x and y values not allowed");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid sub-image specification width and height must be greater than zero");
        }
        this.subImageX = x;
        this.subImageY = y;
        this.subImageWidth = width;
        this.subImageHeight = height;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setT4Options(Integer t4Options) {
        this.t4Options = t4Options;
        return (TiffImagingParameters)this.asThis();
    }

    public TiffImagingParameters setT6Options(Integer t6Options) {
        this.t6Options = t6Options;
        return (TiffImagingParameters)this.asThis();
    }
}

