/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskElementDescriptor;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs.utils.struct.LRUMap;
import org.apache.commons.jcs.utils.timing.ElapsedTimer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockDiskKeyStore<K> {
    private static final Log log = LogFactory.getLog(BlockDiskKeyStore.class);
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private Map<K, int[]> keyHash;
    private final File keyFile;
    protected final String logCacheName;
    private final String fileName;
    private final int maxKeySize;
    protected final BlockDiskCache<K, ?> blockDiskCache;
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private int blockSize;

    public BlockDiskKeyStore(BlockDiskCacheAttributes cacheAttributes, BlockDiskCache<K, ?> blockDiskCache) {
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.blockDiskCacheAttributes.getCacheName() + "] ";
        this.fileName = this.blockDiskCacheAttributes.getCacheName();
        this.maxKeySize = cacheAttributes.getMaxKeySize();
        this.blockDiskCache = blockDiskCache;
        this.diskLimitType = cacheAttributes.getDiskLimitType();
        this.blockSize = cacheAttributes.getBlockSizeBytes();
        File rootDirectory = cacheAttributes.getDiskPath();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Cache file root directory [" + rootDirectory + "]"));
        }
        this.keyFile = new File(rootDirectory, this.fileName + ".key");
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Key File [" + this.keyFile.getAbsolutePath() + "]"));
        }
        if (this.keyFile.length() > 0L) {
            this.loadKeys();
        } else {
            this.initKeyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveKeys() {
        try {
            ElapsedTimer timer = new ElapsedTimer();
            int numKeys = this.keyHash.size();
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Saving keys to [" + this.keyFile.getAbsolutePath() + "], key count [" + numKeys + "]"));
            }
            File file = this.keyFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(this.keyFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    for (Map.Entry<K, int[]> entry : this.keyHash.entrySet()) {
                        BlockDiskElementDescriptor<K> descriptor = new BlockDiskElementDescriptor<K>();
                        descriptor.setKey(entry.getKey());
                        descriptor.setBlocks(entry.getValue());
                        oos.writeObject(descriptor);
                    }
                }
                finally {
                    oos.flush();
                    oos.close();
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Finished saving keys. It took " + timer.getElapsedTimeString() + " to store " + numKeys + " keys.  Key file length [" + this.keyFile.length() + "]"));
            }
        }
        catch (IOException e) {
            log.error((Object)(this.logCacheName + "Problem storing keys."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        File file = this.keyFile;
        synchronized (file) {
            this.clearMemoryMap();
            this.saveKeys();
        }
    }

    protected void clearMemoryMap() {
        this.keyHash.clear();
    }

    private void initKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = this.diskLimitType.equals((Object)IDiskCacheAttributes.DiskLimitType.SIZE) ? new LRUMapSizeLimited(this.maxKeySize) : new LRUMapCountLimited(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Set maxKeySize to: '" + this.maxKeySize + "'"));
            }
        } else {
            this.keyHash = new HashMap<K, int[]>();
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Set maxKeySize to unlimited'"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Loading keys for " + this.keyFile.toString()));
        }
        try {
            this.initKeyMap();
            HashMap keys = new HashMap();
            File file = this.keyFile;
            synchronized (file) {
                FileInputStream fis = new FileInputStream(this.keyFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(bis, null);
                try {
                    try {
                        while (true) {
                            BlockDiskElementDescriptor descriptor;
                            if ((descriptor = (BlockDiskElementDescriptor)ois.readObject()) == null) {
                                continue;
                            }
                            keys.put(descriptor.getKey(), descriptor.getBlocks());
                        }
                    }
                    catch (EOFException eOFException) {
                        ois.close();
                    }
                }
                catch (Throwable throwable) {
                    ois.close();
                    throw throwable;
                }
            }
            if (!keys.isEmpty()) {
                this.keyHash.putAll(keys);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logCacheName + "Found " + keys.size() + " in keys file."));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.logCacheName + "Loaded keys from [" + this.fileName + "], key count: " + this.keyHash.size() + "; up to " + this.maxKeySize + " will be available."));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem loading keys for file " + this.fileName), (Throwable)e);
        }
    }

    public Set<Map.Entry<K, int[]>> entrySet() {
        return this.keyHash.entrySet();
    }

    public Set<K> keySet() {
        return this.keyHash.keySet();
    }

    public int size() {
        return this.keyHash.size();
    }

    public int[] get(K key) {
        return this.keyHash.get(key);
    }

    public void put(K key, int[] value) {
        this.keyHash.put(key, value);
    }

    public int[] remove(K key) {
        return this.keyHash.remove(key);
    }

    public class LRUMapCountLimited
    extends LRUMap<K, int[]> {
        public String tag;

        public LRUMapCountLimited(int maxKeySize) {
            super(maxKeySize);
            this.tag = "orig-lru-count";
        }

        @Override
        protected void processRemovedLRU(K key, int[] value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(value);
            if (log.isDebugEnabled()) {
                log.debug((Object)(BlockDiskKeyStore.this.logCacheName + "Removing key: [" + key + "] from key store."));
                log.debug((Object)(BlockDiskKeyStore.this.logCacheName + "Key store size: [" + super.size() + "]."));
            }
        }
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, int[]> {
        public String tag = "orig-lru-size";
        private AtomicInteger contentSize = new AtomicInteger();
        private int maxSize = -1;

        public LRUMapSizeLimited() {
        }

        public LRUMapSizeLimited(int maxKeySize) {
            this.maxSize = maxKeySize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] put(K key, int[] value) {
            try {
                int[] nArray = super.put(key, value);
                return nArray;
            }
            finally {
                this.contentSize.addAndGet((int)Math.ceil((double)(value.length * BlockDiskKeyStore.this.blockSize) / 1024.0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] remove(Object key) {
            int[] value = null;
            try {
                int[] nArray = value = (int[])super.remove(key);
                return nArray;
            }
            finally {
                if (value != null) {
                    this.contentSize.addAndGet((int)(Math.ceil((double)(value.length * BlockDiskKeyStore.this.blockSize) / 1024.0) * -1.0));
                }
            }
        }

        @Override
        protected void processRemovedLRU(K key, int[] value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(value);
            if (log.isDebugEnabled()) {
                log.debug((Object)(BlockDiskKeyStore.this.logCacheName + "Removing key: [" + key + "] from key store."));
                log.debug((Object)(BlockDiskKeyStore.this.logCacheName + "Key store size: [" + super.size() + "]."));
            }
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.intValue() > this.maxSize && this.size() > 1;
        }
    }
}

