/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessAttributes;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDiskCachePoolAccessManager {
    private static JDBCDiskCachePoolAccessManager instance;
    private final Map<String, JDBCDiskCachePoolAccess> pools = new HashMap<String, JDBCDiskCachePoolAccess>();
    public static final String POOL_CONFIGURATION_PREFIX = "jcs.jdbcconnectionpool.";
    public static final String ATTRIBUTE_PREFIX = ".attributes";
    private static final Log log;

    private JDBCDiskCachePoolAccessManager() {
    }

    public static synchronized JDBCDiskCachePoolAccessManager getInstance() {
        if (instance == null) {
            instance = new JDBCDiskCachePoolAccessManager();
        }
        return instance;
    }

    public synchronized JDBCDiskCachePoolAccess getJDBCDiskCachePoolAccess(String poolName, Properties props) throws SQLException {
        JDBCDiskCachePoolAccess poolAccess = this.pools.get(poolName);
        if (poolAccess == null) {
            JDBCDiskCachePoolAccessAttributes poolAttributes = this.configurePoolAccessAttributes(poolName, props);
            poolAccess = JDBCDiskCachePoolAccessManager.createPoolAccess(poolAttributes);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created shared pooled access for pool name [" + poolName + "]."));
            }
            this.pools.put(poolName, poolAccess);
        }
        return poolAccess;
    }

    protected JDBCDiskCachePoolAccessAttributes configurePoolAccessAttributes(String poolName, Properties props) {
        JDBCDiskCachePoolAccessAttributes poolAttributes = new JDBCDiskCachePoolAccessAttributes();
        String poolAccessAttributePrefix = POOL_CONFIGURATION_PREFIX + poolName + ATTRIBUTE_PREFIX;
        PropertySetter.setProperties(poolAttributes, props, poolAccessAttributePrefix + ".");
        poolAttributes.setPoolName(poolName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Configured attributes " + poolAttributes));
        }
        return poolAttributes;
    }

    public static JDBCDiskCachePoolAccess createPoolAccess(String driverClassName, String poolName, String fullURL, String userName, String password, int maxActive) throws SQLException {
        JDBCDiskCachePoolAccess poolAccess = null;
        if (driverClassName == null) {
            throw new SQLException("Driver class name is null");
        }
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Couldn't find class for driver [" + driverClassName + "]", e);
        }
        poolAccess = new JDBCDiskCachePoolAccess(poolName);
        poolAccess.setupDriver(fullURL, userName, password, maxActive);
        poolAccess.logDriverStats();
        if (log.isInfoEnabled()) {
            log.info((Object)("Created: " + poolAccess));
        }
        return poolAccess;
    }

    public static JDBCDiskCachePoolAccess createPoolAccess(JDBCDiskCacheAttributes cattr) throws SQLException {
        return JDBCDiskCachePoolAccessManager.createPoolAccess(cattr.getDriverClassName(), cattr.getName(), cattr.getUrl() + cattr.getDatabase(), cattr.getUserName(), cattr.getPassword(), cattr.getMaxActive());
    }

    public static JDBCDiskCachePoolAccess createPoolAccess(JDBCDiskCachePoolAccessAttributes poolAttributes) throws SQLException {
        return JDBCDiskCachePoolAccessManager.createPoolAccess(poolAttributes.getDriverClassName(), poolAttributes.getPoolName(), poolAttributes.getUrl() + poolAttributes.getDatabase(), poolAttributes.getUserName(), poolAttributes.getPassword(), poolAttributes.getMaxActive());
    }

    static {
        log = LogFactory.getLog(JDBCDiskCachePoolAccessManager.class);
    }
}

