/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc.hsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheFactory;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.jdbcDriver;

public class HSQLDiskCacheFactory
extends JDBCDiskCacheFactory {
    private static final Log log = LogFactory.getLog(HSQLDiskCacheFactory.class);
    private Set<String> databases;

    @Override
    public <K, V> JDBCDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        this.setupDatabase((JDBCDiskCacheAttributes)rawAttr);
        return super.createCache(rawAttr, compositeCacheManager, cacheEventLogger, elementSerializer);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.databases = Collections.synchronizedSet(new HashSet());
    }

    protected void setupDatabase(JDBCDiskCacheAttributes attributes) throws SQLException {
        if (attributes == null) {
            throw new SQLException("The attributes are null.");
        }
        String database = attributes.getUrl() + attributes.getDatabase();
        if (this.databases.contains(database)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("We already setup database [" + database + "]"));
            }
            return;
        }
        System.setProperty("hsqldb.cache_scale", "8");
        String driver = attributes.getDriverClassName();
        String user = attributes.getUserName();
        String password = attributes.getPassword();
        new jdbcDriver();
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            throw new SQLException("Could not initialize driver " + driver, e);
        }
        Connection cConn = DriverManager.getConnection(database, user, password);
        this.setupTABLE(cConn, attributes.getTableName());
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished setting up database [" + database + "]"));
        }
        this.databases.add(database);
    }

    private void setupTABLE(Connection cConn, String tableName) throws SQLException {
        boolean newT = true;
        StringBuilder createSql = new StringBuilder();
        createSql.append("CREATE CACHED TABLE " + tableName);
        createSql.append("( ");
        createSql.append("CACHE_KEY             VARCHAR(250)          NOT NULL, ");
        createSql.append("REGION                VARCHAR(250)          NOT NULL, ");
        createSql.append("ELEMENT               BINARY, ");
        createSql.append("CREATE_TIME           DATE, ");
        createSql.append("CREATE_TIME_SECONDS   BIGINT, ");
        createSql.append("MAX_LIFE_SECONDS      BIGINT, ");
        createSql.append("SYSTEM_EXPIRE_TIME_SECONDS      BIGINT, ");
        createSql.append("IS_ETERNAL            CHAR(1), ");
        createSql.append("PRIMARY KEY (CACHE_KEY, REGION) ");
        createSql.append(");");
        Statement sStatement = cConn.createStatement();
        try {
            sStatement.executeQuery(createSql.toString());
            sStatement.close();
        }
        catch (SQLException e) {
            if (e.toString().indexOf("already exists") != -1) {
                newT = false;
            }
            throw e;
        }
        String[] setupData = new String[]{"create index iKEY on " + tableName + " (CACHE_KEY, REGION)"};
        if (newT) {
            for (int i = 1; i < setupData.length; ++i) {
                try {
                    sStatement.executeQuery(setupData[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.error((Object)("Exception caught when creating index." + e));
                }
            }
        }
    }
}

