/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRemoteCacheNoWaitFacade<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractRemoteCacheNoWaitFacade.class);
    public RemoteCacheNoWait<K, V>[] noWaits;
    private final String cacheName;
    private IRemoteCacheAttributes remoteCacheAttributes;
    private ICompositeCacheManager compositeCacheManager;

    public AbstractRemoteCacheNoWaitFacade(RemoteCacheNoWait<K, V>[] noWaits, RemoteCacheAttributes rca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CONSTRUCTING NO WAIT FACADE");
        }
        this.noWaits = noWaits;
        this.remoteCacheAttributes = rca;
        this.cacheName = rca.getCacheName();
        this.setCompositeCacheManager(cacheMgr);
        this.setCacheEventLogger(cacheEventLogger);
        this.setElementSerializer(elementSerializer);
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating through cache facade, noWaits.length = " + this.noWaits.length));
        }
        try {
            for (i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].update(ce);
            }
        }
        catch (Exception ex) {
            String message = "Problem updating no wait.  Will initiate failover if the noWait is in error.";
            log.error((Object)message, (Throwable)ex);
            if (this.getCacheEventLogger() != null) {
                this.getCacheEventLogger().logError("RemoteCacheNoWaitFacade", "update", message + ":" + ex.getMessage() + " REGION: " + ce.getCacheName() + " ELEMENT: " + ce);
            }
            this.failover(i);
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        for (int i = 0; i < this.noWaits.length; ++i) {
            try {
                ICacheElement<K, V> obj = this.noWaits[i].get(key);
                if (obj == null) continue;
                return obj;
            }
            catch (IOException ex) {
                log.debug((Object)"Failed to get.");
                return null;
            }
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
        for (int i = 0; i < this.noWaits.length; ++i) {
            try {
                return this.noWaits[i].getMatching(pattern);
            }
            catch (IOException ex) {
                log.debug((Object)"Failed to getMatching.");
                continue;
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            for (int i = 0; i < this.noWaits.length; ++i) {
                try {
                    return this.noWaits[i].getMultiple(keys);
                }
                catch (IOException ex) {
                    log.debug((Object)"Failed to get.");
                    continue;
                }
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet allKeys = new HashSet();
        for (int i = 0; i < this.noWaits.length; ++i) {
            Set keys;
            RemoteCacheNoWait<K, V> aux = this.noWaits[i];
            if (aux == null || (keys = aux.getKeySet()) == null) continue;
            allKeys.addAll(keys);
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].remove(key);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return false;
    }

    @Override
    public void removeAll() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].removeAll();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    @Override
    public void dispose() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Problem in dispose.", (Throwable)ex);
        }
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.REMOTE_CACHE;
    }

    @Override
    public String getCacheName() {
        return this.remoteCacheAttributes.getCacheName();
    }

    @Override
    public CacheStatus getStatus() {
        for (int i = 0; i < this.noWaits.length; ++i) {
            if (this.noWaits[i].getStatus() != CacheStatus.ALIVE) continue;
            return CacheStatus.ALIVE;
        }
        return CacheStatus.DISPOSED;
    }

    public String toString() {
        return "RemoteCacheNoWaitFacade: " + this.cacheName + ", rca = " + this.remoteCacheAttributes;
    }

    abstract void failover(int var1);

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait Facade");
        ArrayList elems = new ArrayList();
        if (this.noWaits != null) {
            elems.add(new StatElement<Integer>("Number of No Waits", this.noWaits.length));
            for (RemoteCacheNoWait<K, V> rcnw : this.noWaits) {
                IStats sStats = rcnw.getStatistics();
                elems.addAll(sStats.getStatElements());
            }
        }
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Remote Cache No Wait Facade";
    }

    public IRemoteCacheAttributes getRemoteCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    public void setRemoteCacheAttributes(IRemoteCacheAttributes rca) {
        this.remoteCacheAttributes = rca;
    }

    protected void setCompositeCacheManager(ICompositeCacheManager compositeCacheManager) {
        this.compositeCacheManager = compositeCacheManager;
    }

    protected ICompositeCacheManager getCompositeCacheManager() {
        return this.compositeCacheManager;
    }
}

