/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.jcs.auxiliary.remote.AbstractRemoteAuxiliaryCache;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCache<K, V>
extends AbstractRemoteAuxiliaryCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCache.class);

    public RemoteCache(IRemoteCacheAttributes cattr, ICacheServiceNonLocal<K, V> remote, IRemoteCacheListener<K, V> listener) {
        super(cattr, remote, listener);
        RemoteUtils.configureGlobalCustomSocketFactory(this.getRemoteCacheAttributes().getRmiSocketFactoryTimeoutMillis());
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<String>("Remote Host:Port", this.getIPAddressForService()));
        elems.add(new StatElement<String>("Remote Type", this.getRemoteCacheAttributes().getRemoteTypeName()));
        IStats sStats = super.getStatistics();
        elems.addAll(sStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    protected void handleException(Exception ex, String msg, String eventName) throws IOException {
        String message = "Disabling remote cache due to error: " + msg;
        this.logError(this.cacheName, "", message);
        log.error((Object)message, (Throwable)ex);
        if (this.getRemoteCacheService() == null || !(this.getRemoteCacheService() instanceof ZombieCacheServiceNonLocal)) {
            this.setRemoteCacheService(new ZombieCacheServiceNonLocal(this.getRemoteCacheAttributes().getZombieQueueMaxSize()));
        }
        RemoteCacheMonitor.getInstance().notifyError();
        RemoteCacheNoWaitFacade<?, ?> rcnwf = RemoteCacheFactory.getFacades().get(this.getRemoteCacheAttributes().getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initiating failover, rcnf = " + rcnwf));
        }
        if (rcnwf != null && rcnwf.getRemoteCacheAttributes().getRemoteType() == RemoteType.LOCAL) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found facade, calling failover");
            }
            rcnwf.failover(0);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public String toString() {
        return "RemoteCache: " + this.cacheName + " attributes = " + this.getRemoteCacheAttributes();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return this.getIPAddressForService();
    }

    protected String getIPAddressForService() {
        String ipAddress = this.getRemoteCacheAttributes().getRemoteHost() + ":" + this.getRemoteCacheAttributes().getRemotePort();
        return ipAddress;
    }
}

