/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.util.Iterator;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheRestore;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(RemoteCacheMonitor.class);
    private static RemoteCacheMonitor instance;
    private static long idlePeriod;
    private boolean alright = true;
    static final int TIME = 0;
    static final int ERROR = 1;
    static int mode;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > RemoteCacheMonitor.idlePeriod) {
            RemoteCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    private RemoteCacheMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteCacheMonitor getInstance() {
        Class<RemoteCacheMonitor> clazz = RemoteCacheMonitor.class;
        synchronized (RemoteCacheMonitor.class) {
            if (instance == null) {
                instance = new RemoteCacheMonitor();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        log.debug((Object)"Notified of an error.");
        this.bad();
        RemoteCacheMonitor remoteCacheMonitor = this;
        synchronized (remoteCacheMonitor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug((Object)"Monitoring daemon started");
        block12: while (true) {
            Object object;
            if (mode == 1) {
                object = this;
                synchronized (object) {
                    if (this.alright) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"FAILURE DRIVEN MODE: cache monitor waiting for error");
                            }
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TIME DRIVEN MODE: cache monitor sleeping for " + idlePeriod));
            }
            try {
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this.alright = true;
            }
            object = RemoteCacheManager.instances.values().iterator();
            block13: while (true) {
                if (!object.hasNext()) continue block12;
                RemoteCacheManager mgr = (RemoteCacheManager)object.next();
                try {
                    RemoteCacheNoWait<?, ?> c;
                    Iterator<RemoteCacheNoWait<?, ?>> iterator = mgr.caches.values().iterator();
                    do {
                        if (!iterator.hasNext()) continue block13;
                    } while ((c = iterator.next()).getStatus() != CacheStatus.ERROR);
                    RemoteCacheRestore repairer = new RemoteCacheRestore(mgr);
                    if (repairer.canFix()) {
                        repairer.fix();
                        continue;
                    }
                    this.bad();
                    continue;
                }
                catch (Exception ex) {
                    this.bad();
                    log.error((Object)("Problem fixing caches for manager." + mgr), (Throwable)ex);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private synchronized void bad() {
        this.alright = false;
    }

    static {
        idlePeriod = 30000L;
        mode = 1;
    }
}

