/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheDispatcher;
import org.apache.commons.jcs.auxiliary.remote.http.client.AbstractHttpClient;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCacheDispatcher
extends AbstractHttpClient
implements IRemoteCacheDispatcher {
    private static final String PARAMETER_REQUEST_TYPE = "RequestType";
    private static final String PARAMETER_KEY = "Key";
    private static final String PARAMETER_CACHE_NAME = "CacheName";
    private static final Log log = LogFactory.getLog(RemoteHttpCacheDispatcher.class);
    private StandardSerializer serializer = new StandardSerializer();

    public RemoteHttpCacheDispatcher(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        super(remoteHttpCacheAttributes);
    }

    @Override
    public <K, V, T> RemoteCacheResponse<T> dispatchRequest(RemoteCacheRequest<K, V> remoteCacheRequest) throws IOException {
        try {
            byte[] requestAsByteArray = this.serializer.serialize(remoteCacheRequest);
            String url = this.addParameters(remoteCacheRequest, this.getRemoteHttpCacheAttributes().getUrl());
            byte[] responseAsByteArray = this.processRequest(requestAsByteArray, url);
            RemoteCacheResponse remoteCacheResponse = null;
            try {
                remoteCacheResponse = (RemoteCacheResponse)this.serializer.deSerialize(responseAsByteArray, null);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Couldn't deserialize the response.", (Throwable)e);
            }
            return remoteCacheResponse;
        }
        catch (Exception e) {
            log.error((Object)"Problem dispatching request.", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected byte[] processRequest(byte[] requestAsByteArray, String url) throws IOException, HttpException {
        PostMethod post = new PostMethod(url);
        ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(requestAsByteArray);
        post.setRequestEntity((RequestEntity)requestEntity);
        this.doWebserviceCall((HttpMethod)post);
        byte[] response = post.getResponseBody();
        return response;
    }

    protected <K, V> String addParameters(RemoteCacheRequest<K, V> remoteCacheRequest, String baseUrl) {
        StringBuilder url = new StringBuilder(baseUrl);
        try {
            if (baseUrl != null && baseUrl.indexOf("?") == -1) {
                url.append("?");
            } else {
                url.append("&");
            }
            if (this.getRemoteHttpCacheAttributes().isIncludeCacheNameAsParameter() && remoteCacheRequest.getCacheName() != null) {
                url.append("CacheName=" + URLEncoder.encode(remoteCacheRequest.getCacheName(), "UTF-8"));
            }
            if (this.getRemoteHttpCacheAttributes().isIncludeKeysAndPatternsAsParameter()) {
                String keyValue = "";
                switch (remoteCacheRequest.getRequestType()) {
                    case GET: {
                        keyValue = remoteCacheRequest.getKey() + "";
                        break;
                    }
                    case REMOVE: {
                        keyValue = remoteCacheRequest.getKey() + "";
                        break;
                    }
                    case GET_MATCHING: {
                        keyValue = remoteCacheRequest.getPattern();
                        break;
                    }
                    case GET_MULTIPLE: {
                        keyValue = remoteCacheRequest.getKeySet() + "";
                        break;
                    }
                    case GET_KEYSET: {
                        keyValue = remoteCacheRequest.getKey() + "";
                        break;
                    }
                    case UPDATE: {
                        keyValue = remoteCacheRequest.getCacheElement().getKey() + "";
                        break;
                    }
                }
                String encodedKeyValue = URLEncoder.encode(keyValue, "UTF-8");
                url.append("&Key=" + encodedKeyValue);
            }
            if (this.getRemoteHttpCacheAttributes().isIncludeRequestTypeasAsParameter()) {
                url.append("&RequestType=" + URLEncoder.encode(remoteCacheRequest.getRequestType().toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Couldn't encode URL.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Url: " + url.toString()));
        }
        return url.toString();
    }

    @Override
    public HttpState preProcessWebserviceCall(HttpMethod post) throws IOException {
        return null;
    }

    @Override
    public void postProcessWebserviceCall(HttpMethod post, HttpState httpState) throws IOException {
    }
}

