/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledCacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(PooledCacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.POOLED;
    private ThreadPoolExecutor pool = null;

    public PooledCacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        this.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, threadPoolName);
    }

    @Override
    public void initialize(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = listener;
        this.listenerId = listenerId;
        this.cacheName = cacheName;
        this.maxFailure = maxFailure <= 0 ? 3 : maxFailure;
        this.waitBeforeRetry = waitBeforeRetry <= 0 ? 500 : waitBeforeRetry;
        this.pool = ThreadPoolManager.getInstance().getPool(threadPoolName == null ? "cache_event_queue" : threadPoolName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initialized: " + this));
        }
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    public synchronized void stopProcessing() {
        this.destroyed = true;
    }

    @Override
    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.pool.shutdownNow();
            if (log.isInfoEnabled()) {
                log.info((Object)("Cache event queue destroyed: " + this));
            }
        }
    }

    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent event) {
        this.pool.execute(event);
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Pooled Cache Event Queue");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Working", super.isWorking()));
        elems.add(new StatElement<Boolean>("Alive", this.isAlive()));
        elems.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        if (this.pool.getQueue() != null) {
            BlockingQueue<Runnable> bb = this.pool.getQueue();
            elems.add(new StatElement<Integer>("Queue Size", bb.size()));
            elems.add(new StatElement<Integer>("Queue Capacity", bb.remainingCapacity()));
        }
        elems.add(new StatElement<Integer>("Pool Size", this.pool.getPoolSize()));
        elems.add(new StatElement<Integer>("Maximum Pool Size", this.pool.getMaximumPoolSize()));
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        if (this.pool.getQueue() == null) {
            return true;
        }
        return this.pool.getQueue().size() == 0;
    }

    @Override
    public int size() {
        if (this.pool.getQueue() == null) {
            return 0;
        }
        return this.pool.getQueue().size();
    }
}

