/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.ObjectNotFoundException;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.event.ElementEvent;
import org.apache.commons.jcs.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs.engine.memory.shrinking.ShrinkerThread;
import org.apache.commons.jcs.engine.stats.CacheStats;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCache<K, V>
implements ICache<K, V>,
IRequireScheduler {
    private static final Log log = LogFactory.getLog(CompositeCache.class);
    private IElementEventQueue elementEventQ;
    private AuxiliaryCache<K, V>[] auxCaches = new AuxiliaryCache[0];
    private boolean alive = true;
    private IElementAttributes attr;
    private ICompositeCacheAttributes cacheAttr;
    private int updateCount;
    private int removeCount;
    private int hitCountRam;
    private int hitCountAux;
    private int missCountNotFound = 0;
    private int missCountExpired = 0;
    private IMemoryCache<K, V> memCache;
    private IKeyMatcher<K> keyMatcher = new KeyMatcherPatternImpl();

    public CompositeCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        this.attr = attr;
        this.cacheAttr = cattr;
        this.createMemoryCache(cattr);
        if (log.isInfoEnabled()) {
            log.info((Object)("Constructed cache with name [" + this.cacheAttr.getCacheName() + "] and cache attributes " + cattr));
        }
    }

    public void setElementEventQueue(IElementEventQueue queue) {
        this.elementEventQ = queue;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.cacheAttr.isUseMemoryShrinker()) {
            scheduledExecutor.scheduleAtFixedRate(new ShrinkerThread(this), 0L, this.cacheAttr.getShrinkerIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    public void setAuxCaches(AuxiliaryCache<K, V>[] auxCaches) {
        this.auxCaches = auxCaches;
    }

    public AuxiliaryCache<K, V>[] getAuxCaches() {
        return this.auxCaches;
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.update(ce, false);
    }

    public void localUpdate(ICacheElement<K, V> ce) throws IOException {
        this.update(ce, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ICacheElement<K, V> cacheElement, boolean localOnly) throws IOException {
        if (cacheElement.getKey() instanceof String && cacheElement.getKey().toString().endsWith(":")) {
            throw new IllegalArgumentException("key must not end with : for a put operation");
        }
        if (cacheElement.getKey() instanceof GroupId) {
            throw new IllegalArgumentException("key cannot be a GroupId  for a put operation");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating memory cache " + cacheElement.getKey()));
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            ++this.updateCount;
            this.memCache.update(cacheElement);
            this.updateAuxiliaries(cacheElement, localOnly);
            cacheElement.getElementAttributes().setLastAccessTimeNow();
        }
    }

    protected void updateAuxiliaries(ICacheElement<K, V> cacheElement, boolean localOnly) throws IOException {
        if (log.isDebugEnabled()) {
            if (this.auxCaches.length > 0) {
                log.debug((Object)"Updating auxiliary caches");
            } else {
                log.debug((Object)"No auxiliary cache to update");
            }
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Auxilliary cache type: " + (Object)((Object)aux.getCacheType())));
            }
            if (aux == null) continue;
            if (aux.getCacheType() == ICacheType.CacheType.REMOTE_CACHE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ce.getElementAttributes().getIsRemote() = " + cacheElement.getElementAttributes().getIsRemote()));
                }
                if (!cacheElement.getElementAttributes().getIsRemote() || localOnly) continue;
                try {
                    aux.update(cacheElement);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Updated remote store for " + cacheElement.getKey() + cacheElement));
                }
                catch (IOException ex) {
                    log.error((Object)"Failure in updateExclude", (Throwable)ex);
                }
                continue;
            }
            if (aux.getCacheType() == ICacheType.CacheType.LATERAL_CACHE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("lateralcache in aux list: cattr " + this.cacheAttr.isUseLateral()));
                }
                if (!this.cacheAttr.isUseLateral() || !cacheElement.getElementAttributes().getIsLateral() || localOnly) continue;
                aux.update(cacheElement);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("updated lateral cache for " + cacheElement.getKey()));
                continue;
            }
            if (aux.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("diskcache in aux list: cattr " + this.cacheAttr.isUseDisk()));
            }
            if (!this.cacheAttr.isUseDisk() || this.cacheAttr.getDiskUsagePattern() != ICompositeCacheAttributes.DiskUsagePattern.UPDATE || !cacheElement.getElementAttributes().getIsSpool()) continue;
            aux.update(cacheElement);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("updated disk cache for " + cacheElement.getKey()));
        }
    }

    public void spoolToDisk(ICacheElement<K, V> ce) {
        if (!ce.getElementAttributes().getIsSpool()) {
            this.handleElementEvent(ce, ElementEventType.SPOOLED_NOT_ALLOWED);
            return;
        }
        boolean diskAvailable = false;
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null || aux.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            diskAvailable = true;
            if (this.cacheAttr.getDiskUsagePattern() == ICompositeCacheAttributes.DiskUsagePattern.SWAP) {
                try {
                    this.handleElementEvent(ce, ElementEventType.SPOOLED_DISK_AVAILABLE);
                    aux.update(ce);
                }
                catch (IOException ex) {
                    log.error((Object)"Problem spooling item to disk cache.", (Throwable)ex);
                    throw new IllegalStateException(ex.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("spoolToDisk done for: " + ce.getKey() + " on disk cache[" + i + "]"));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"DiskCache avaialbe, but JCS is not configured to use the DiskCache as a swap.");
        }
        if (!diskAvailable) {
            try {
                this.handleElementEvent(ce, ElementEventType.SPOOLED_DISK_NOT_AVAILABLE);
            }
            catch (Exception e) {
                log.error((Object)"Trouble handling the ELEMENT_EVENT_SPOOLED_DISK_NOT_AVAILABLE  element event", (Throwable)e);
            }
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        return this.get(key, false);
    }

    public ICacheElement<K, V> localGet(K key) {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement<K, V> get(K key, boolean localOnly) {
        ICacheElement<K, V> element = null;
        boolean found = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("get: key = " + key + ", localOnly = " + localOnly));
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            block24: {
                try {
                    element = this.memCache.get(key);
                    if (element != null) {
                        if (this.isExpired(element)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.cacheAttr.getCacheName() + " - Memory cache hit, but element expired"));
                            }
                            ++this.missCountExpired;
                            this.remove(key);
                            element = null;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.cacheAttr.getCacheName() + " - Memory cache hit"));
                            }
                            ++this.hitCountRam;
                        }
                        found = true;
                        break block24;
                    }
                    for (int i = 0; i < this.auxCaches.length; ++i) {
                        AuxiliaryCache<K, V> aux = this.auxCaches[i];
                        if (aux == null) continue;
                        ICacheType.CacheType cacheType = aux.getCacheType();
                        if (!localOnly || cacheType == ICacheType.CacheType.DISK_CACHE) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Attempting to get from aux [" + aux.getCacheName() + "] which is of type: " + (Object)((Object)cacheType)));
                            }
                            try {
                                element = aux.get(key);
                            }
                            catch (IOException e) {
                                log.error((Object)"Error getting from aux", (Throwable)e);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Got CacheElement: " + element));
                        }
                        if (element == null) continue;
                        if (this.isExpired(element)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.cacheAttr.getCacheName() + " - Aux cache[" + i + "] hit, but element expired."));
                            }
                            ++this.missCountExpired;
                            this.remove(key);
                            element = null;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.cacheAttr.getCacheName() + " - Aux cache[" + i + "] hit"));
                            }
                            ++this.hitCountAux;
                            this.copyAuxiliaryRetrievedItemToMemory(element);
                        }
                        found = true;
                        break;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Problem encountered getting element.", (Throwable)e);
                }
            }
        }
        if (!found) {
            ++this.missCountNotFound;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheAttr.getCacheName() + " - Miss"));
            }
        }
        if (element != null) {
            element.getElementAttributes().setLastAccessTimeNow();
        }
        return element;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        return this.getMultiple(keys, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMultiple(Set<K> keys) {
        return this.getMultiple(keys, true);
    }

    protected Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys, boolean localOnly) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("get: key = " + keys + ", localOnly = " + localOnly));
        }
        try {
            elements.putAll(this.getMultipleFromMemory(keys));
            if (elements.size() != keys.size()) {
                Set<K> remainingKeys = this.pruneKeysFound(keys, elements);
                elements.putAll(this.getMultipleFromAuxiliaryCaches(remainingKeys, localOnly));
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem encountered getting elements.", (Throwable)e);
        }
        if (elements.size() != keys.size()) {
            this.missCountNotFound += keys.size() - elements.size();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheAttr.getCacheName() + " - " + (keys.size() - elements.size()) + " Misses"));
            }
        }
        return elements;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromMemory(Set<K> keys) throws IOException {
        Map<K, ICacheElement<K, V>> elementsFromMemory = this.memCache.getMultiple(keys);
        for (ICacheElement<K, V> element : new HashMap<K, ICacheElement<K, V>>(elementsFromMemory).values()) {
            if (element == null) continue;
            if (this.isExpired(element)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.cacheAttr.getCacheName() + " - Memory cache hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(element.getKey());
                elementsFromMemory.remove(element.getKey());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheAttr.getCacheName() + " - Memory cache hit"));
            }
            ++this.hitCountRam;
        }
        return elementsFromMemory;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromAuxiliaryCaches(Set<K> keys, boolean localOnly) throws IOException {
        HashMap elements = new HashMap();
        Set<K> remainingKeys = new HashSet<K>(keys);
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null) continue;
            HashMap elementsFromAuxiliary = new HashMap();
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (!localOnly || cacheType == ICacheType.CacheType.DISK_CACHE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to get from aux [" + aux.getCacheName() + "] which is of type: " + (Object)((Object)cacheType)));
                }
                try {
                    elementsFromAuxiliary.putAll(aux.getMultiple(remainingKeys));
                }
                catch (IOException e) {
                    log.error((Object)"Error getting from aux", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got CacheElements: " + elementsFromAuxiliary));
            }
            this.processRetrievedElements(i, elementsFromAuxiliary);
            elements.putAll(elementsFromAuxiliary);
            if (elements.size() == keys.size()) break;
            remainingKeys = this.pruneKeysFound(keys, elements);
        }
        return elements;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        return this.getMatching(pattern, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMatching(String pattern) {
        return this.getMatching(pattern, true);
    }

    protected Map<K, ICacheElement<K, V>> getMatching(String pattern, boolean localOnly) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("get: pattern [" + pattern + "], localOnly = " + localOnly));
        }
        try {
            elements.putAll(this.getMatchingFromAuxiliaryCaches(pattern, localOnly));
            elements.putAll(this.getMatchingFromMemory(pattern));
        }
        catch (Exception e) {
            log.error((Object)"Problem encountered getting elements.", (Throwable)e);
        }
        return elements;
    }

    protected Map<K, ICacheElement<K, V>> getMatchingFromMemory(String pattern) throws IOException {
        Set<K> keyArray = this.memCache.getKeySet();
        Set<K> matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        return this.getMultipleFromMemory(matchingKeys);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromAuxiliaryCaches(String pattern, boolean localOnly) throws IOException {
        HashMap elements = new HashMap();
        for (int i = this.auxCaches.length - 1; i >= 0; --i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null) continue;
            HashMap elementsFromAuxiliary = new HashMap();
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (localOnly && cacheType != ICacheType.CacheType.DISK_CACHE) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to get from aux [" + aux.getCacheName() + "] which is of type: " + (Object)((Object)cacheType)));
            }
            try {
                elementsFromAuxiliary.putAll(aux.getMatching(pattern));
            }
            catch (IOException e) {
                log.error((Object)"Error getting from aux", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got CacheElements: " + elementsFromAuxiliary));
            }
            this.processRetrievedElements(i, elementsFromAuxiliary);
            elements.putAll(elementsFromAuxiliary);
        }
        return elements;
    }

    private void processRetrievedElements(int i, Map<K, ICacheElement<K, V>> elementsFromAuxiliary) throws IOException {
        for (ICacheElement<K, V> element : new HashMap<K, ICacheElement<K, V>>(elementsFromAuxiliary).values()) {
            if (element == null) continue;
            if (this.isExpired(element)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.cacheAttr.getCacheName() + " - Aux cache[" + i + "] hit, but element expired."));
                }
                ++this.missCountExpired;
                this.remove(element.getKey());
                elementsFromAuxiliary.remove(element.getKey());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheAttr.getCacheName() + " - Aux cache[" + i + "] hit"));
            }
            ++this.hitCountAux;
            this.copyAuxiliaryRetrievedItemToMemory(element);
        }
    }

    private void copyAuxiliaryRetrievedItemToMemory(ICacheElement<K, V> element) throws IOException {
        if (this.memCache.getCacheAttributes().getMaxObjects() > 0) {
            this.memCache.update(element);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Skipping memory update since no items are allowed in memory");
        }
    }

    private Set<K> pruneKeysFound(Set<K> keys, Map<K, ICacheElement<K, V>> foundElements) {
        HashSet<K> remainingKeys = new HashSet<K>(keys);
        for (K key : foundElements.keySet()) {
            remainingKeys.remove(key);
        }
        return remainingKeys;
    }

    public Set<K> getKeySet() {
        return this.getKeySet(false);
    }

    public Set<K> getKeySet(boolean localOnly) {
        HashSet<K> allKeys = new HashSet<K>();
        allKeys.addAll(this.memCache.getKeySet());
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null || localOnly && aux.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            try {
                allKeys.addAll(aux.getKeySet());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        return this.remove(key, false);
    }

    public boolean localRemove(K key) {
        return this.remove(key, true);
    }

    protected synchronized boolean remove(K key, boolean localOnly) {
        ++this.removeCount;
        boolean removed = false;
        try {
            removed = this.memCache.remove(key);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null) continue;
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (localOnly && (cacheType == ICacheType.CacheType.REMOTE_CACHE || cacheType == ICacheType.CacheType.LATERAL_CACHE)) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing " + key + " from cacheType" + (Object)((Object)cacheType)));
                }
                boolean b = aux.remove(key);
                if (removed || cacheType == ICacheType.CacheType.REMOTE_CACHE) continue;
                removed = b;
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"Failure removing from aux", (Throwable)ex);
            }
        }
        return removed;
    }

    @Override
    public void removeAll() throws IOException {
        this.removeAll(false);
    }

    public void localRemoveAll() throws IOException {
        this.removeAll(true);
    }

    protected synchronized void removeAll(boolean localOnly) throws IOException {
        try {
            this.memCache.removeAll();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Removed All keys from the memory cache.");
            }
        }
        catch (IOException ex) {
            log.error((Object)"Trouble updating memory cache.", (Throwable)ex);
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache<K, V> aux = this.auxCaches[i];
            if (aux == null || aux.getCacheType() != ICacheType.CacheType.DISK_CACHE && localOnly) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing All keys from cacheType" + (Object)((Object)aux.getCacheType())));
                }
                aux.removeAll();
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"Failure removing all from aux", (Throwable)ex);
            }
        }
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public synchronized void dispose(boolean fromRemote) {
        if (log.isInfoEnabled()) {
            log.info((Object)("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] fromRemote [" + fromRemote + "]"));
        }
        if (!this.alive) {
            return;
        }
        this.alive = false;
        if (this.elementEventQ != null) {
            this.elementEventQ.dispose();
            this.elementEventQ = null;
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            try {
                AuxiliaryCache<K, V> aux = this.auxCaches[i];
                if (aux == null || aux.getStatus() != CacheStatus.ALIVE || fromRemote && aux.getCacheType() == ICacheType.CacheType.REMOTE_CACHE) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] SKIPPING auxiliary [" + aux.getCacheName() + "] fromRemote [" + fromRemote + "]"));
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] auxiliary [" + aux.getCacheName() + "]"));
                }
                if (aux.getCacheType() == ICacheType.CacheType.DISK_CACHE) {
                    int numToFree = this.memCache.getSize();
                    this.memCache.freeElements(numToFree);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] put " + numToFree + " into auxiliary " + aux.getCacheName()));
                    }
                }
                aux.dispose();
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"Failure disposing of aux.", (Throwable)ex);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] disposing of memory cache."));
        }
        try {
            this.memCache.dispose();
        }
        catch (IOException ex) {
            log.error((Object)"Failure disposing of memCache", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            for (int i = 0; i < this.auxCaches.length; ++i) {
                try {
                    AuxiliaryCache<K, V> aux = this.auxCaches[i];
                    if (aux.getStatus() != CacheStatus.ALIVE) continue;
                    for (K key : this.memCache.getKeySet()) {
                        ICacheElement<K, V> ce = this.memCache.get(key);
                        if (ce == null) continue;
                        aux.update(ce);
                    }
                    continue;
                }
                catch (IOException ex) {
                    log.error((Object)"Failure saving aux caches.", (Throwable)ex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Called save for [" + this.cacheAttr.getCacheName() + "]"));
        }
    }

    @Override
    public int getSize() {
        return this.memCache.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    @Override
    public synchronized CacheStatus getStatus() {
        return this.alive ? CacheStatus.ALIVE : CacheStatus.DISPOSED;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    public ICacheStats getStatistics() {
        CacheStats stats = new CacheStats();
        stats.setRegionName(this.getCacheName());
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("HitCountRam", this.getHitCountRam()));
        elems.add(new StatElement<Integer>("HitCountAux", this.getHitCountAux()));
        stats.setStatElements(elems);
        int total = this.auxCaches.length + 1;
        ArrayList<IStats> auxStats = new ArrayList<IStats>(total);
        auxStats.add(this.getMemoryCache().getStatistics());
        for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            auxStats.add(aux.getStatistics());
        }
        stats.setAuxiliaryCacheStats(auxStats);
        return stats;
    }

    @Override
    public String getCacheName() {
        return this.cacheAttr.getCacheName();
    }

    public IElementAttributes getElementAttributes() {
        if (this.attr != null) {
            return this.attr.copy();
        }
        return null;
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttr = cattr;
        this.memCache.initialize(this);
    }

    public IElementAttributes getElementAttributes(K key) throws CacheException, IOException {
        ICacheElement<K, V> ce = this.get(key);
        if (ce == null) {
            throw new ObjectNotFoundException("key " + key + " is not found");
        }
        return ce.getElementAttributes();
    }

    public boolean isExpired(ICacheElement<K, V> element) {
        return this.isExpired(element, System.currentTimeMillis(), ElementEventType.EXCEEDED_MAXLIFE_ONREQUEST, ElementEventType.EXCEEDED_IDLETIME_ONREQUEST);
    }

    public boolean isExpired(ICacheElement<K, V> element, long timestamp, ElementEventType eventMaxlife, ElementEventType eventIdle) {
        try {
            IElementAttributes attributes = element.getElementAttributes();
            if (!attributes.getIsEternal()) {
                long maxLifeSeconds = attributes.getMaxLife();
                long createTime = attributes.getCreateTime();
                long timeFactorForMilliseconds = attributes.getTimeFactorForMilliseconds();
                if (maxLifeSeconds != -1L && timestamp - createTime > maxLifeSeconds * timeFactorForMilliseconds) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exceeded maxLife: " + element.getKey()));
                    }
                    this.handleElementEvent(element, eventMaxlife);
                    return true;
                }
                long idleTime = attributes.getIdleTime();
                long lastAccessTime = attributes.getLastAccessTime();
                if (idleTime != -1L && timestamp - lastAccessTime > idleTime * timeFactorForMilliseconds) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)("Exceeded maxIdle: " + element.getKey()));
                    }
                    this.handleElementEvent(element, eventIdle);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error determining expiration period, expiring", (Throwable)e);
            return true;
        }
        return false;
    }

    public void handleElementEvent(ICacheElement<K, V> element, ElementEventType eventType) {
        ArrayList<IElementEventHandler> eventHandlers = element.getElementAttributes().getElementEventHandlers();
        if (eventHandlers != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Element Handlers are registered.  Create event type " + (Object)((Object)eventType)));
            }
            if (this.elementEventQ == null) {
                log.warn((Object)("No element event queue available for cache " + this.getCacheName()));
                return;
            }
            ElementEvent<ICacheElement<K, V>> event = new ElementEvent<ICacheElement<K, V>>(element, eventType);
            for (IElementEventHandler hand : eventHandlers) {
                try {
                    this.elementEventQ.addElementEvent(hand, event);
                }
                catch (IOException e) {
                    log.error((Object)"Trouble adding element event to queue", (Throwable)e);
                }
            }
        }
    }

    private void createMemoryCache(ICompositeCacheAttributes cattr) {
        if (this.memCache == null) {
            try {
                IMemoryCache newInstance;
                Class<?> c = Class.forName(cattr.getMemoryCacheName());
                this.memCache = newInstance = (IMemoryCache)c.newInstance();
                this.memCache.initialize(this);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to init mem cache, using: LRUMemoryCache", (Throwable)e);
                this.memCache = new LRUMemoryCache();
                this.memCache.initialize(this);
            }
        } else {
            log.warn((Object)"Refusing to create memory cache -- already exists.");
        }
    }

    public IMemoryCache<K, V> getMemoryCache() {
        return this.memCache;
    }

    public int getHitCountRam() {
        return this.hitCountRam;
    }

    public int getHitCountAux() {
        return this.hitCountAux;
    }

    public int getMissCountNotFound() {
        return this.missCountNotFound;
    }

    public int getMissCountExpired() {
        return this.missCountExpired;
    }

    @Override
    public void setKeyMatcher(IKeyMatcher<K> keyMatcher) {
        if (keyMatcher != null) {
            this.keyMatcher = keyMatcher;
        }
    }

    public IKeyMatcher<K> getKeyMatcher() {
        return this.keyMatcher;
    }

    public synchronized void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    public synchronized int getUpdateCount() {
        return this.updateCount;
    }

    public synchronized void setRemoveCount(int removeCount) {
        this.removeCount = removeCount;
    }

    public synchronized int getRemoveCount() {
        return this.removeCount;
    }

    public String toString() {
        return this.getStats();
    }
}

