/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.utils.discovery.DiscoveredService;
import org.apache.commons.jcs.utils.discovery.UDPCleanupRunner;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs.utils.discovery.UDPDiscoverySenderThread;
import org.apache.commons.jcs.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoveryService
implements IShutdownObserver,
IRequireScheduler {
    private static final Log log = LogFactory.getLog(UDPDiscoveryService.class);
    private Thread udpReceiverThread;
    private UDPDiscoveryReceiver receiver;
    private UDPDiscoverySenderThread sender = null;
    private UDPDiscoveryAttributes udpDiscoveryAttributes = null;
    private boolean shutdown = false;
    private Set<DiscoveredService> discoveredServices = new CopyOnWriteArraySet<DiscoveredService>();
    private final Set<String> cacheNames = new CopyOnWriteArraySet<String>();
    private final Set<IDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<IDiscoveryListener>();

    public UDPDiscoveryService(UDPDiscoveryAttributes attributes) {
        this.udpDiscoveryAttributes = (UDPDiscoveryAttributes)attributes.clone();
        try {
            this.udpDiscoveryAttributes.setServiceAddress(HostNameUtil.getLocalHostAddress());
        }
        catch (UnknownHostException e1) {
            log.error((Object)"Couldn't get localhost address", (Throwable)e1);
        }
        try {
            this.receiver = new UDPDiscoveryReceiver(this, this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort());
            this.udpReceiverThread = new Thread(this.receiver);
            this.udpReceiverThread.setDaemon(true);
            this.udpReceiverThread.start();
        }
        catch (Exception e) {
            log.error((Object)("Problem creating UDPDiscoveryReceiver, address [" + this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr() + "] port [" + this.getUdpDiscoveryAttributes().getUdpDiscoveryPort() + "] we won't be able to find any other caches"), (Throwable)e);
        }
        this.sender = new UDPDiscoverySenderThread(this.getUdpDiscoveryAttributes(), this.getCacheNames());
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.sender != null) {
            scheduledExecutor.scheduleAtFixedRate(this.sender, 0L, 15L, TimeUnit.SECONDS);
        }
        UDPCleanupRunner cleanup = new UDPCleanupRunner(this);
        scheduledExecutor.scheduleAtFixedRate(cleanup, 0L, this.getUdpDiscoveryAttributes().getMaxIdleTimeSec(), TimeUnit.SECONDS);
    }

    protected void serviceRequestBroadcast() {
        UDPDiscoverySender sender1 = null;
        try {
            sender1 = new UDPDiscoverySender(this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort());
            sender1.passiveBroadcast(this.getUdpDiscoveryAttributes().getServiceAddress(), this.getUdpDiscoveryAttributes().getServicePort(), this.getCacheNames());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Called sender to issue a passive broadcast");
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem calling the UDP Discovery Sender. address [" + this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr() + "] port [" + this.getUdpDiscoveryAttributes().getUdpDiscoveryPort() + "]"), (Throwable)e);
        }
        finally {
            try {
                if (sender1 != null) {
                    sender1.destroy();
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem closing Passive Broadcast sender, while servicing a request broadcast.", (Throwable)e);
            }
        }
    }

    public void addParticipatingCacheName(String cacheName) {
        this.cacheNames.add(cacheName);
        this.sender.setCacheNames(this.getCacheNames());
    }

    public void removeDiscoveredService(DiscoveredService service) {
        boolean contained = this.getDiscoveredServices().remove(service);
        if (contained && log.isInfoEnabled()) {
            log.info((Object)("Removing " + service));
        }
        for (IDiscoveryListener listener : this.getDiscoveryListeners()) {
            listener.removeDiscoveredService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOrUpdateService(DiscoveredService discoveredService) {
        Set<DiscoveredService> set = this.getDiscoveredServices();
        synchronized (set) {
            if (!this.getDiscoveredServices().contains(discoveredService)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Set does not contain service. I discovered " + discoveredService));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding service in the set " + discoveredService));
                }
                this.getDiscoveredServices().add(discoveredService);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Set contains service.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating service in the set " + discoveredService));
                }
                DiscoveredService theOldServiceInformation = null;
                for (DiscoveredService service1 : this.getDiscoveredServices()) {
                    if (!discoveredService.equals(service1)) continue;
                    theOldServiceInformation = service1;
                    break;
                }
                if (theOldServiceInformation != null && !theOldServiceInformation.getCacheNames().equals(discoveredService.getCacheNames()) && log.isInfoEnabled()) {
                    log.info((Object)("List of cache names changed for service: " + discoveredService));
                }
                this.getDiscoveredServices().remove(discoveredService);
                this.getDiscoveredServices().add(discoveredService);
            }
        }
        for (IDiscoveryListener listener : this.getDiscoveryListeners()) {
            listener.addDiscoveredService(discoveredService);
        }
    }

    protected ArrayList<String> getCacheNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.cacheNames);
        return names;
    }

    public void setUdpDiscoveryAttributes(UDPDiscoveryAttributes attr) {
        this.udpDiscoveryAttributes = attr;
    }

    public UDPDiscoveryAttributes getUdpDiscoveryAttributes() {
        return this.udpDiscoveryAttributes;
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (log.isInfoEnabled()) {
                log.info((Object)"Shutting down UDP discovery service receiver.");
            }
            try {
                this.receiver.shutdown();
                this.udpReceiverThread.interrupt();
            }
            catch (Exception e) {
                log.error((Object)"Problem interrupting UDP receiver thread.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Shutting down UDP discovery service sender.");
            }
            try {
                this.sender.shutdown();
            }
            catch (Exception e) {
                log.error((Object)"Problem issuing remove broadcast via UDP sender.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Shutdown already called.");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public synchronized void setDiscoveredServices(Set<DiscoveredService> discoveredServices) {
        this.discoveredServices = discoveredServices;
    }

    public synchronized Set<DiscoveredService> getDiscoveredServices() {
        return this.discoveredServices;
    }

    private Set<IDiscoveryListener> getDiscoveryListeners() {
        return this.discoveryListeners;
    }

    public Set<IDiscoveryListener> getCopyOfDiscoveryListeners() {
        HashSet<IDiscoveryListener> copy = new HashSet<IDiscoveryListener>();
        copy.addAll(this.getDiscoveryListeners());
        return copy;
    }

    public boolean addDiscoveryListener(IDiscoveryListener listener) {
        return this.getDiscoveryListeners().add(listener);
    }

    public boolean removeDiscoveryListener(IDiscoveryListener listener) {
        return this.getDiscoveryListeners().remove(listener);
    }
}

