/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.proxy;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.commons.jcs.jcache.JCSCache;

public class ClassLoaderAwareCache<K extends Serializable, V extends Serializable>
implements Cache<K, V> {
    private final ClassLoader loader;
    private final JCSCache<K, V> delegate;

    public ClassLoaderAwareCache(ClassLoader loader, JCSCache<K, V> delegate) {
        this.loader = loader;
        this.delegate = delegate;
    }

    private ClassLoader before(Thread thread) {
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        return tccl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Serializable serializable = (Serializable)this.delegate.get(key);
            return (V)serializable;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getAll(Set<? extends K> keys) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Map<? extends K, V> map = this.delegate.getAll(keys);
            return map;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.loadAll(keys, replaceExistingValues, completionListener);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.put(key, value);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, V value) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Serializable serializable = (Serializable)this.delegate.getAndPut(key, value);
            return (V)serializable;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.putAll(map);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(K key, V value) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.putIfAbsent(key, value);
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.remove(key);
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V oldValue) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.remove(key, oldValue);
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndRemove(K key) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Serializable serializable = (Serializable)this.delegate.getAndRemove(key);
            return (V)serializable;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.replace(key, oldValue, newValue);
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V value) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.replace(key, value);
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndReplace(K key, V value) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Serializable serializable = (Serializable)this.delegate.getAndReplace(key, value);
            return (V)serializable;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<? extends K> keys) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.removeAll(keys);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public void removeAll() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.removeAll();
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public void clear() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.clear();
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            C c = this.delegate.getConfiguration(clazz);
            return c;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            T t = this.delegate.invoke(key, entryProcessor, arguments);
            return t;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Map<? extends K, EntryProcessorResult<T>> map = this.delegate.invokeAll(keys, entryProcessor, arguments);
            return map;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            String string = this.delegate.getName();
            return string;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            CacheManager cacheManager = this.delegate.getCacheManager();
            return cacheManager;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public void close() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.close();
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            boolean bl = this.delegate.isClosed();
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unwrap(Class<T> clazz) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            T t = this.delegate.unwrap(clazz);
            return t;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.registerCacheEntryListener(cacheEntryListenerConfiguration);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            this.delegate.deregisterCacheEntryListener(cacheEntryListenerConfiguration);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Cache.Entry<K, V>> iterator() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.before(thread);
        try {
            Iterator<Cache.Entry<K, V>> iterator = this.delegate.iterator();
            return iterator;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public boolean equals(Object obj) {
        if (ClassLoaderAwareCache.class.isInstance(obj)) {
            return this.delegate.equals(((ClassLoaderAwareCache)ClassLoaderAwareCache.class.cast((Object)obj)).delegate);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static <K extends Serializable, V extends Serializable> Cache<K, V> wrap(ClassLoader loader, JCSCache<K, V> delegate) {
        for (ClassLoader dontWrapLoader = ClassLoaderAwareCache.class.getClassLoader(); dontWrapLoader != null; dontWrapLoader = dontWrapLoader.getParent()) {
            if (loader != dontWrapLoader) continue;
            return delegate;
        }
        return new ClassLoaderAwareCache<K, V>(loader, delegate);
    }

    public static <K extends Serializable, V extends Serializable> JCSCache<K, V> getDelegate(Cache<?, ?> cache) {
        if (JCSCache.class.isInstance(cache)) {
            return (JCSCache)cache;
        }
        return ((ClassLoaderAwareCache)cache).delegate;
    }
}

