/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.logging.Log;

public class JexlBuilder {
    protected static final int CACHE_THRESHOLD = 64;
    private JexlUberspect uberspect = null;
    private JexlUberspect.ResolverStrategy strategy = null;
    private JexlSandbox sandbox = null;
    private Log logger = null;
    private Boolean silent = null;
    private Boolean strict = null;
    private Boolean debug = null;
    private Boolean cancellable = null;
    private Map<String, Object> namespaces = null;
    private JexlArithmetic arithmetic = null;
    private int cache = -1;
    private int cacheThreshold = 64;
    private Charset charset = Charset.defaultCharset();
    private ClassLoader loader = null;

    public JexlBuilder uberspect(JexlUberspect u) {
        this.uberspect = u;
        return this;
    }

    public JexlUberspect uberspect() {
        return this.uberspect;
    }

    public JexlBuilder strategy(JexlUberspect.ResolverStrategy rs) {
        this.strategy = rs;
        return this;
    }

    public JexlUberspect.ResolverStrategy strategy() {
        return this.strategy;
    }

    public JexlBuilder arithmetic(JexlArithmetic a) {
        this.arithmetic = a;
        return this;
    }

    public JexlArithmetic arithmetic() {
        return this.arithmetic;
    }

    public JexlBuilder sandbox(JexlSandbox box) {
        this.sandbox = box;
        return this;
    }

    public JexlSandbox sandbox() {
        return this.sandbox;
    }

    public JexlBuilder logger(Log l) {
        this.logger = l;
        return this;
    }

    public Log logger() {
        return this.logger;
    }

    public JexlBuilder loader(ClassLoader l) {
        this.loader = l;
        return this;
    }

    public ClassLoader loader() {
        return this.loader;
    }

    public JexlBuilder loader(Charset arg) {
        this.charset = arg;
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public JexlBuilder silent(boolean flag) {
        this.silent = flag;
        return this;
    }

    public Boolean silent() {
        return this.silent;
    }

    public JexlBuilder strict(boolean flag) {
        this.strict = flag;
        return this;
    }

    public Boolean strict() {
        return this.strict;
    }

    public JexlBuilder debug(boolean flag) {
        this.debug = flag;
        return this;
    }

    public Boolean debug() {
        return this.debug;
    }

    public JexlBuilder cancellable(boolean flag) {
        this.cancellable = flag;
        return this;
    }

    public Boolean cancellable() {
        return this.cancellable;
    }

    public JexlBuilder namespaces(Map<String, Object> ns) {
        this.namespaces = ns;
        return this;
    }

    public Map<String, Object> namespaces() {
        return this.namespaces;
    }

    public JexlBuilder cache(int size) {
        this.cache = size;
        return this;
    }

    public int cache() {
        return this.cache;
    }

    public JexlBuilder cacheThreshold(int length) {
        this.cacheThreshold = length > 0 ? length : 64;
        return this;
    }

    public int cacheThreshold() {
        return this.cacheThreshold;
    }

    public JexlEngine create() {
        return new Engine(this);
    }
}

