/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.ml.distance;

import org.apache.commons.math4.ml.distance.DistanceMeasure;
import org.apache.commons.math4.util.FastMath;

public class CanberraDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -6972277381587032228L;

    @Override
    public double compute(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double num = FastMath.abs(a[i] - b[i]);
            double denom = FastMath.abs(a[i]) + FastMath.abs(b[i]);
            sum += num == 0.0 && denom == 0.0 ? 0.0 : num / denom;
        }
        return sum;
    }
}

