/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;

public class LogBinomialCoefficient {
    private LogBinomialCoefficient() {
    }

    public static double value(int n, int k) {
        int i;
        BinomialCoefficient.checkBinomial(n, k);
        if (n == k || k == 0) {
            return 0.0;
        }
        if (k == 1 || k == n - 1) {
            return Math.log(n);
        }
        if (n < 67) {
            return Math.log(BinomialCoefficient.value(n, k));
        }
        if (n < 1030) {
            return Math.log(BinomialCoefficientDouble.value(n, k));
        }
        if (k > n / 2) {
            return LogBinomialCoefficient.value(n, n - k);
        }
        double logSum = 0.0;
        for (i = n - k + 1; i <= n; ++i) {
            logSum += Math.log(i);
        }
        for (i = 2; i <= k; ++i) {
            logSum -= Math.log(i);
        }
        return logSum;
    }
}

