/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.math.BigInteger;
import java.text.MessageFormat;

public final class ArithmeticUtils {
    private static final String OVERFLOW_GCD_MESSAGE_2_POWER_63 = "overflow: gcd({0}, {1}) is 2^63";
    private static final String NEGATIVE_EXPONENT_1 = "negative exponent ({";
    private static final String NEGATIVE_EXPONENT_2 = "})";

    private ArithmeticUtils() {
    }

    public static int gcd(int p, int q) {
        int negatedGcd;
        int b;
        int a = p > 0 ? -p : p;
        int n = b = q > 0 ? -q : q;
        if (a == 0) {
            negatedGcd = b;
        } else if (b == 0) {
            negatedGcd = a;
        } else {
            int aTwos = Integer.numberOfTrailingZeros(a);
            int bTwos = Integer.numberOfTrailingZeros(b);
            a >>= aTwos;
            b >>= bTwos;
            int shift = Math.min(aTwos, bTwos);
            while (a != b) {
                int delta = a - b;
                b = Math.max(a, b);
                a = delta > 0 ? -delta : delta;
                a >>= Integer.numberOfTrailingZeros(a);
            }
            negatedGcd = a << shift;
        }
        if (negatedGcd == Integer.MIN_VALUE) {
            throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
        }
        return -negatedGcd;
    }

    public static long gcd(long p, long q) {
        long t;
        int k;
        long u = p;
        long v = q;
        if (u == 0L || v == 0L) {
            if (u == Long.MIN_VALUE || v == Long.MIN_VALUE) {
                throw new NumbersArithmeticException(OVERFLOW_GCD_MESSAGE_2_POWER_63, p, q);
            }
            return Math.abs(u) + Math.abs(v);
        }
        if (u > 0L) {
            u = -u;
        }
        if (v > 0L) {
            v = -v;
        }
        for (k = 0; (u & 1L) == 0L && (v & 1L) == 0L && k < 63; ++k) {
            u /= 2L;
            v /= 2L;
        }
        if (k == 63) {
            throw new NumbersArithmeticException(OVERFLOW_GCD_MESSAGE_2_POWER_63, p, q);
        }
        long l = t = (u & 1L) == 1L ? v : -(u / 2L);
        while (true) {
            if ((t & 1L) == 0L) {
                t /= 2L;
                continue;
            }
            if (t > 0L) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = (v - u) / 2L) == 0L) break;
        }
        return -u * (1L << k);
    }

    public static int lcm(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        int lcm = Math.abs(Math.multiplyExact(a / ArithmeticUtils.gcd(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new NumbersArithmeticException("overflow: lcm({0}, {1}) is 2^31", a, b);
        }
        return lcm;
    }

    public static long lcm(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long lcm = Math.abs(Math.multiplyExact(a / ArithmeticUtils.gcd(a, b), b));
        if (lcm == Long.MIN_VALUE) {
            throw new NumbersArithmeticException("overflow: lcm({0}, {1}) is 2^63", a, b);
        }
        return lcm;
    }

    public static int pow(int k, int e) {
        if (e < 0) {
            throw new IllegalArgumentException(NEGATIVE_EXPONENT_1 + e + NEGATIVE_EXPONENT_2);
        }
        int exp = e;
        int result = 1;
        int k2p = k;
        while (true) {
            if ((exp & 1) != 0) {
                result = Math.multiplyExact(result, k2p);
            }
            if ((exp >>= 1) == 0) break;
            k2p = Math.multiplyExact(k2p, k2p);
        }
        return result;
    }

    public static long pow(long k, int e) {
        if (e < 0) {
            throw new IllegalArgumentException(NEGATIVE_EXPONENT_1 + e + NEGATIVE_EXPONENT_2);
        }
        int exp = e;
        long result = 1L;
        long k2p = k;
        while (true) {
            if ((exp & 1) != 0) {
                result = Math.multiplyExact(result, k2p);
            }
            if ((exp >>= 1) == 0) break;
            k2p = Math.multiplyExact(k2p, k2p);
        }
        return result;
    }

    public static BigInteger pow(BigInteger k, int e) {
        if (e < 0) {
            throw new IllegalArgumentException(NEGATIVE_EXPONENT_1 + e + NEGATIVE_EXPONENT_2);
        }
        return k.pow(e);
    }

    public static BigInteger pow(BigInteger k, long e) {
        if (e < 0L) {
            throw new IllegalArgumentException(NEGATIVE_EXPONENT_1 + e + NEGATIVE_EXPONENT_2);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k;
        while (e != 0L) {
            if ((e & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e >>= 1;
        }
        return result;
    }

    public static BigInteger pow(BigInteger k, BigInteger e) {
        if (e.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(NEGATIVE_EXPONENT_1 + e + NEGATIVE_EXPONENT_2);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k;
        while (!BigInteger.ZERO.equals(e)) {
            if (e.testBit(0)) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e = e.shiftRight(1);
        }
        return result;
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static int remainderUnsigned(int dividend, int divisor) {
        if (divisor >= 0) {
            int q;
            if (dividend >= 0) {
                return dividend % divisor;
            }
            if ((dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0 || dividend >= divisor) {
                dividend -= divisor;
            }
            return dividend;
        }
        return dividend >= 0 || dividend < divisor ? dividend : dividend - divisor;
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q;
            if (dividend >= 0L) {
                return dividend % divisor;
            }
            if ((dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0L || dividend >= divisor) {
                dividend -= divisor;
            }
            return dividend;
        }
        return dividend >= 0L || dividend < divisor ? dividend : dividend - divisor;
    }

    public static int divideUnsigned(int dividend, int divisor) {
        if (divisor >= 0) {
            int q;
            if (dividend >= 0) {
                return dividend / divisor;
            }
            if ((long)(dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0L || dividend >= divisor) {
                ++q;
            }
            return q;
        }
        return dividend >= 0 || dividend < divisor ? 0 : 1;
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q;
            if (dividend >= 0L) {
                return dividend / divisor;
            }
            if ((dividend -= (q = (dividend >>> 1) / divisor << 1) * divisor) < 0L || dividend >= divisor) {
                ++q;
            }
            return q;
        }
        return dividend >= 0L || dividend < divisor ? 0L : 1L;
    }

    private static class NumbersArithmeticException
    extends ArithmeticException {
        private static final long serialVersionUID = 20180130L;

        NumbersArithmeticException() {
            this("arithmetic exception", new Object[0]);
        }

        NumbersArithmeticException(String message, Object ... args) {
            super(MessageFormat.format(message, args));
        }
    }
}

