/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import org.apache.commons.numbers.core.Precision;
import org.apache.commons.numbers.fraction.FractionException;

public abstract class ContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-9;

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double x) {
        return this.evaluate(x, 1.0E-9, Integer.MAX_VALUE);
    }

    public double evaluate(double x, double epsilon) {
        return this.evaluate(x, epsilon, Integer.MAX_VALUE);
    }

    public double evaluate(double x, int maxIterations) {
        return this.evaluate(x, 1.0E-9, maxIterations);
    }

    public double evaluate(double x, double epsilon, int maxIterations) {
        double small = 1.0E-50;
        double hPrev = this.getA(0, x);
        if (Precision.equals((double)hPrev, (double)0.0, (double)1.0E-50)) {
            hPrev = 1.0E-50;
        }
        double dPrev = 0.0;
        double cPrev = hPrev;
        for (int n = 1; n <= maxIterations; ++n) {
            double deltaN;
            double hN;
            double cN;
            double b;
            double a = this.getA(n, x);
            double dN = a + (b = this.getB(n, x)) * dPrev;
            if (Precision.equals((double)dN, (double)0.0, (double)1.0E-50)) {
                dN = 1.0E-50;
            }
            if (Precision.equals((double)(cN = a + b / cPrev), (double)0.0, (double)1.0E-50)) {
                cN = 1.0E-50;
            }
            if (Double.isInfinite(hN = hPrev * (deltaN = cN * (dN = 1.0 / dN)))) {
                throw new FractionException("Continued fraction convergents diverged to +/- infinity for value {0}", x);
            }
            if (Double.isNaN(hN)) {
                throw new FractionException("Continued fraction diverged to NaN for value {0}", x);
            }
            if (Math.abs(deltaN - 1.0) < epsilon) {
                return hN;
            }
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        throw new FractionException("maximal count ({0}) exceeded", maxIterations);
    }
}

