/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.Erfc;
import org.apache.commons.numbers.gamma.InverseErfc;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class LevyDistribution
extends AbstractContinuousDistribution {
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(double mu, double c) {
        this.mu = mu;
        this.c = c;
        this.halfC = 0.5 * c;
    }

    @Override
    public double density(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return Math.sqrt(f / Math.PI) * Math.exp(-f) / delta;
    }

    @Override
    public double logDensity(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return 0.5 * Math.log(f / Math.PI) - f - Math.log(delta);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        return Erfc.value((double)Math.sqrt(this.halfC / (x - this.mu)));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        double t = InverseErfc.value((double)p);
        return this.mu + this.halfC / (t * t);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    @Override
    public double getMean() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getSupportLowerBound() {
        return this.mu;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

