/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class WeibullDistribution
extends AbstractContinuousDistribution {
    private final double shape;
    private final double scale;

    public WeibullDistribution(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new DistributionException("Number {0} is negative", alpha);
        }
        if (beta <= 0.0) {
            throw new DistributionException("Number {0} is negative", beta);
        }
        this.scale = beta;
        this.shape = alpha;
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double xscale = x / this.scale;
        double xscalepow = Math.pow(xscale, this.shape - 1.0);
        double xscalepowshape = xscalepow * xscale;
        return this.shape / this.scale * xscalepow * Math.exp(-xscalepowshape);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double xscale = x / this.scale;
        double logxscalepow = Math.log(xscale) * (this.shape - 1.0);
        double xscalepowshape = Math.exp(logxscalepow) * xscale;
        return Math.log(this.shape / this.scale) + logxscalepow - xscalepowshape;
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - Math.exp(-Math.pow(x / this.scale, this.shape));
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        double ret = p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : this.scale * Math.pow(-Math.log1p(-p), 1.0 / this.shape));
        return ret;
    }

    @Override
    public double getMean() {
        double sh = this.getShape();
        double sc = this.getScale();
        return sc * Math.exp(LogGamma.value((double)(1.0 + 1.0 / sh)));
    }

    @Override
    public double getVariance() {
        double sh = this.getShape();
        double sc = this.getScale();
        double mn = this.getMean();
        return sc * sc * Math.exp(LogGamma.value((double)(1.0 + 2.0 / sh))) - mn * mn;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

