/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaroWinklerDistance
implements SimilarityScore<Double> {
    public static final int INDEX_NOT_FOUND = -1;

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        double defaultScalingFactor = 0.1;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int[] mtp = JaroWinklerDistance.matches(left, right);
        double m = mtp[0];
        if (m == 0.0) {
            return 0.0;
        }
        double j = (m / (double)left.length() + m / (double)right.length() + (m - (double)mtp[1]) / m) / 3.0;
        double jw = j < 0.7 ? j : j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - j);
        return jw;
    }

    protected static int[] matches(CharSequence first, CharSequence second) {
        CharSequence min;
        CharSequence max;
        if (first.length() > second.length()) {
            max = first;
            min = second;
        } else {
            max = second;
            min = first;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        int mi = 0;
        while (mi < min.length()) {
            char c1 = min.charAt(mi);
            int xi = Math.max(mi - range, 0);
            int xn = Math.min(mi + range + 1, max.length());
            while (xi < xn) {
                if (!matchFlags[xi] && c1 == max.charAt(xi)) {
                    matchIndexes[mi] = xi;
                    matchFlags[xi] = true;
                    ++matches;
                    break;
                }
                ++xi;
            }
            ++mi;
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int i = 0;
        int si = 0;
        while (i < min.length()) {
            if (matchIndexes[i] != -1) {
                ms1[si] = min.charAt(i);
                ++si;
            }
            ++i;
        }
        i = 0;
        si = 0;
        while (i < max.length()) {
            if (matchFlags[i]) {
                ms2[si] = max.charAt(i);
                ++si;
            }
            ++i;
        }
        int transpositions = 0;
        int mi2 = 0;
        while (mi2 < ms1.length) {
            if (ms1[mi2] != ms2[mi2]) {
                ++transpositions;
            }
            ++mi2;
        }
        int prefix = 0;
        int mi3 = 0;
        while (mi3 < min.length()) {
            if (first.charAt(mi3) != second.charAt(mi3)) break;
            ++prefix;
            ++mi3;
        }
        return new int[]{matches, transpositions / 2, prefix, max.length()};
    }
}

