/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

public final class DateStringLookup
extends AbstractStringLookup {
    public static final DateStringLookup INSTANCE = new DateStringLookup();

    private DateStringLookup() {
    }

    private String formatDate(long date, String format) {
        DateFormat dateFormat = null;
        if (format != null) {
            try {
                dateFormat = new SimpleDateFormat(format);
            }
            catch (Exception ex) {
                throw IllegalArgumentExceptions.format(ex, "Invalid date format: [%s], using default", format);
            }
        }
        if (dateFormat == null) {
            dateFormat = DateFormat.getInstance();
        }
        return dateFormat.format(new Date(date));
    }

    @Override
    public String lookup(String key) {
        return this.formatDate(System.currentTimeMillis(), key);
    }
}

