/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.ssl.asn1.ASN1OutputStream;
import org.apache.commons.ssl.asn1.BERConstructedOctetString;
import org.apache.commons.ssl.asn1.DEREncodable;
import org.apache.commons.ssl.asn1.DEROctetString;
import org.apache.commons.ssl.asn1.DERSequence;
import org.apache.commons.ssl.asn1.DERTaggedObject;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int tag, DEREncodable obj) {
        super(tag, obj);
    }

    public BERTaggedObject(boolean explicit, int tag, DEREncodable obj) {
        super(explicit, tag, obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(ASN1OutputStream out) throws IOException {
        out.write(0xA0 | this.tag);
        out.write(128);
        if (!this.empty) {
            if (!this.explicit) {
                if (this.obj instanceof DEROctetString) {
                    Enumeration e;
                    if (this.obj instanceof BERConstructedOctetString) {
                        e = ((BERConstructedOctetString)this.obj).getObjects();
                    } else {
                        DEROctetString octs = (DEROctetString)this.obj;
                        BERConstructedOctetString berO = new BERConstructedOctetString(octs.getOctets());
                        e = berO.getObjects();
                    }
                    while (e.hasMoreElements()) {
                        out.writeObject(e.nextElement());
                    }
                } else {
                    if (!(this.obj instanceof DERSequence)) throw new RuntimeException("Not implemented: " + this.obj.getClass().getName());
                    Enumeration e = ((DERSequence)this.obj).getObjects();
                    while (e.hasMoreElements()) {
                        out.writeObject(e.nextElement());
                    }
                }
            } else {
                out.writeObject(this.obj);
            }
        }
        out.write(0);
        out.write(0);
    }
}

