/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import org.apache.cxf.common.logging.LogUtils;

public class BeanValidationAnnotationIntrospector
extends AnnotationIntrospector {
    private static final transient Logger LOG = LogUtils.getL7dLogger(BeanValidationAnnotationIntrospector.class);
    protected final TypeFactory typeFactory;

    public BeanValidationAnnotationIntrospector(TypeFactory typeFactory) {
        this.typeFactory = typeFactory == null ? TypeFactory.defaultInstance() : typeFactory;
    }

    public Version version() {
        return new Version(1, 1, 0, "", "cxf", "json-schema-mbean");
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        int fieldModifiers;
        Class declaringClass;
        String fieldName;
        Field field;
        AnnotatedMethod method;
        String methodName;
        Member member = m.getMember();
        int modifiers = member.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Ignoring transient member " + m);
            }
            return true;
        }
        if (m instanceof AnnotatedMethod && (methodName = (method = (AnnotatedMethod)m).getName()).startsWith("get") && method.getParameterCount() == 0 && (field = BeanValidationAnnotationIntrospector.findField(fieldName = Introspector.decapitalize(methodName.substring(3)), declaringClass = method.getDeclaringClass())) != null && Modifier.isTransient(fieldModifiers = field.getModifiers())) {
            LOG.fine("Ignoring member " + m + " due to transient field called " + fieldName);
            return true;
        }
        return super.hasIgnoreMarker(m);
    }

    protected static Field findField(String fieldName, Class<?> declaringClass) {
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass != null && superclass != declaringClass) {
                return BeanValidationAnnotationIntrospector.findField(fieldName, superclass);
            }
            return null;
        }
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        NotNull annotation = (NotNull)m.getAnnotation(NotNull.class);
        if (annotation == null) {
            return null;
        }
        return Boolean.TRUE;
    }
}

