/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.util.DestinationResolver;
import org.apache.cxf.transport.jms.util.JMSDestinationResolver;

@NoJSR250Annotations
public class JMSConfiguration {
    public static final int DEFAULT_VALUE = -1;
    private ConnectionFactory connectionFactory;
    private Properties jndiEnvironment;
    private String connectionFactoryName;
    private String userName;
    private String password;
    private DestinationResolver destinationResolver = new JMSDestinationResolver();
    private boolean reconnectOnException = true;
    private boolean pubSubNoLocal;
    private Long clientReceiveTimeout = 60000L;
    private Long serverReceiveTimeout;
    private boolean explicitQosEnabled;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean sessionTransacted;
    private int maxSuspendedContinuations = -1;
    private int reconnectPercentOfMax = 70;
    private volatile String messageSelector;
    private boolean subscriptionDurable;
    private String durableSubscriptionClientId;
    private String durableSubscriptionName;
    private String targetDestination;
    private String replyDestination;
    private Destination replyDestinationDest;
    private String replyToDestination;
    private String messageType = "text";
    private boolean pubSubDomain;
    private boolean replyPubSubDomain;
    private boolean useConduitIdSelector = true;
    private String conduitSelectorPrefix;
    private boolean jmsProviderTibcoEms;
    private String targetService;
    private String requestURI;

    public void ensureProperlyConfigured() {
        ConnectionFactory cf = this.getConnectionFactory();
        if (cf == null) {
            throw new IllegalArgumentException("connectionFactory may not be null");
        }
        if (this.targetDestination == null) {
            throw new IllegalArgumentException("targetDestination may not be null");
        }
    }

    public Properties getJndiEnvironment() {
        return this.jndiEnvironment;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiEnvironment = jndiEnvironment;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public Long getReceiveTimeout() {
        return this.clientReceiveTimeout;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.clientReceiveTimeout = receiveTimeout;
    }

    public Long getServerReceiveTimeout() {
        return this.serverReceiveTimeout;
    }

    public void setServerReceiveTimeout(Long receiveTimeout) {
        this.serverReceiveTimeout = receiveTimeout;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setConduitSelectorPrefix(String conduitSelectorPrefix) {
        this.conduitSelectorPrefix = conduitSelectorPrefix;
    }

    public String getConduitSelectorPrefix() {
        if (this.conduitSelectorPrefix == null) {
            return "";
        }
        return this.conduitSelectorPrefix;
    }

    public boolean isSetConduitSelectorPrefix() {
        return this.conduitSelectorPrefix != null;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            throw new RuntimeException("Required property connectionfactory was not set");
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getTargetDestination() {
        return this.targetDestination;
    }

    public void setTargetDestination(String targetDestination) {
        this.targetDestination = targetDestination;
    }

    public String getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(String replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getReplyToDestination() {
        return this.replyToDestination != null ? this.replyToDestination : this.replyDestination;
    }

    public void setReplyToDestination(String replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isReplyPubSubDomain() {
        return this.replyPubSubDomain;
    }

    public void setReplyPubSubDomain(boolean replyPubSubDomain) {
        this.replyPubSubDomain = replyPubSubDomain;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    @Deprecated
    public void setTransactionManager(Object transactionManager) {
    }

    public int getMaxSuspendedContinuations() {
        return this.maxSuspendedContinuations;
    }

    public void setMaxSuspendedContinuations(int maxSuspendedContinuations) {
        this.maxSuspendedContinuations = maxSuspendedContinuations;
    }

    public int getReconnectPercentOfMax() {
        return this.reconnectPercentOfMax;
    }

    public void setReconnectPercentOfMax(int reconnectPercentOfMax) {
        this.reconnectPercentOfMax = reconnectPercentOfMax;
    }

    public void setUseConduitIdSelector(boolean useConduitIdSelector) {
        this.useConduitIdSelector = useConduitIdSelector;
    }

    public boolean isUseConduitIdSelector() {
        return this.useConduitIdSelector;
    }

    public boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    public synchronized ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = JMSFactory.getConnectionFactoryFromJndi(this);
        }
        return this.connectionFactory;
    }

    public String getDurableSubscriptionClientId() {
        return this.durableSubscriptionClientId;
    }

    public void setDurableSubscriptionClientId(String durableSubscriptionClientId) {
        this.durableSubscriptionClientId = durableSubscriptionClientId;
    }

    public void setTargetService(String targetService) {
        this.targetService = targetService;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public boolean isJmsProviderTibcoEms() {
        return this.jmsProviderTibcoEms;
    }

    public void setJmsProviderTibcoEms(boolean jmsProviderTibcoEms) {
        this.jmsProviderTibcoEms = jmsProviderTibcoEms;
    }

    public static Destination resolveOrCreateDestination(Session session, DestinationResolver resolver, String replyToDestinationName, boolean pubSubDomain) throws JMSException {
        if (replyToDestinationName == null) {
            return session.createTemporaryQueue();
        }
        return resolver.resolveDestinationName(session, replyToDestinationName, pubSubDomain);
    }

    public Destination getReplyToDestination(Session session, String userDestination) throws JMSException {
        if (userDestination == null) {
            return this.getReplyDestination(session);
        }
        return this.destinationResolver.resolveDestinationName(session, userDestination, this.replyPubSubDomain);
    }

    public synchronized Destination getReplyDestination(Session session) throws JMSException {
        if (this.replyDestinationDest == null) {
            this.replyDestinationDest = this.replyDestination == null ? session.createTemporaryQueue() : this.destinationResolver.resolveDestinationName(session, this.replyDestination, this.replyPubSubDomain);
        }
        return this.replyDestinationDest;
    }

    public Destination getTargetDestination(Session session) throws JMSException {
        return this.destinationResolver.resolveDestinationName(session, this.targetDestination, this.pubSubDomain);
    }

    public Destination getReplyDestination(Session session, String replyToName) throws JMSException {
        return this.destinationResolver.resolveDestinationName(session, replyToName, this.replyPubSubDomain);
    }
}

