/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.transport.jms.continuations.Counter;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;

public class ThrottlingCounter
implements Counter {
    private AtomicInteger counter = new AtomicInteger();
    private final int lowWatermark;
    private final int highWatermark;
    private final JMSListenerContainer listenerContainer;

    public ThrottlingCounter(JMSListenerContainer listenerContainer, int lowWatermark, int highWatermark) {
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
        this.listenerContainer = listenerContainer;
    }

    @Override
    public final int incrementAndGet() {
        int curCounter = this.counter.incrementAndGet();
        if (this.highWatermark >= 0 && curCounter >= this.highWatermark && this.listenerContainer.isRunning()) {
            this.listenerContainer.stop();
        }
        return curCounter;
    }

    @Override
    public final int decrementAndGet() {
        int curCounter = this.counter.decrementAndGet();
        if (curCounter <= this.lowWatermark && !this.listenerContainer.isRunning()) {
            this.listenerContainer.start();
        }
        return curCounter;
    }
}

