/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class MessageListenerContainer
implements JMSListenerContainer {
    private Connection connection;
    private Destination replyTo;
    private MessageListener listenerHandler;
    private boolean transacted;
    private int acknowledgeMode = 1;
    private String messageSelector;
    private boolean running;
    private MessageConsumer consumer;
    private Session session;
    private Executor executor;
    private String durableSubscriptionName;
    private boolean pubSubNoLocal;

    public MessageListenerContainer(Connection connection, Destination replyTo, MessageListener listenerHandler) {
        this.connection = connection;
        this.replyTo = replyTo;
        this.listenerHandler = listenerHandler;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    private Executor getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(10);
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        try {
            this.session = this.connection.createSession(this.transacted, this.acknowledgeMode);
            this.consumer = this.durableSubscriptionName != null ? this.session.createDurableSubscriber((Topic)this.replyTo, this.durableSubscriptionName, this.messageSelector, this.pubSubNoLocal) : this.session.createConsumer(this.replyTo, this.messageSelector);
            this.consumer.setMessageListener(this.listenerHandler);
            this.running = true;
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
    }

    @Override
    public void stop() {
        this.running = false;
        ResourceCloser.close(this.consumer);
        ResourceCloser.close(this.session);
        this.consumer = null;
        this.session = null;
    }

    @Override
    public void shutdown() {
        this.stop();
        ResourceCloser.close(this.connection);
    }

    class DispachingListener
    implements MessageListener {
        DispachingListener() {
        }

        public void onMessage(final Message message) {
            MessageListenerContainer.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageListenerContainer.this.listenerHandler.onMessage(message);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

