/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMCaptureOutInterceptor;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

public class RMOutInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMOutInterceptor.class);

    public RMOutInterceptor() {
        super("pre-stream");
        this.addAfter(RMCaptureOutInterceptor.class.getName());
    }

    @Override
    protected void handle(Message msg) throws SequenceFault, RMException {
        RMProperties rmpsIn;
        AddressingProperties maps = ContextUtils.retrieveMAPs(msg, false, true, false);
        if (null == maps) {
            LogUtils.log(LOG, Level.WARNING, "MAPS_RETRIEVAL_FAILURE_MSG");
            return;
        }
        if (Boolean.TRUE.equals(msg.get("org.apache.cxf.ws.rm.retransmitting"))) {
            return;
        }
        if (this.isRuntimeFault(msg)) {
            return;
        }
        RMConfiguration config = this.getManager().getEffectiveConfiguration(msg);
        String wsaNamespace = config.getAddressingNamespace();
        String rmNamespace = config.getRMNamespace();
        ProtocolVariation protocol = ProtocolVariation.findVariant(rmNamespace, wsaNamespace);
        RMContextUtils.setProtocolVariation(msg, protocol);
        Destination destination = this.getManager().getDestination(msg);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        boolean isPartialResponse = MessageUtils.isPartialResponse(msg);
        RMConstants constants = protocol.getConstants();
        RMProperties rmpsOut = RMContextUtils.retrieveRMProperties(msg, true);
        if (isApplicationMessage && !isPartialResponse) {
            this.addRetransmissionInterceptor(msg);
        }
        Identifier inSeqId = null;
        if (isApplicationMessage && null != (rmpsIn = RMContextUtils.retrieveRMProperties(msg, false)) && null != rmpsIn.getSequence()) {
            inSeqId = rmpsIn.getSequence().getIdentifier();
        }
        if (isApplicationMessage || constants.getSequenceAckAction().equals(action)) {
            AttributedURIType to = maps.getTo();
            assert (null != to);
            this.addAcknowledgements(destination, rmpsOut, inSeqId, to);
            if (isPartialResponse && rmpsOut.getAcks() != null && rmpsOut.getAcks().size() > 0) {
                RMOutInterceptor.setAction(maps, constants.getSequenceAckAction());
                msg.remove("org.apache.cxf.partial.response.empty");
            }
        }
        if (constants.getSequenceAckAction().equals(action) || constants.getTerminateSequenceAction().equals(action)) {
            maps.setReplyTo(RMUtils.createNoneReference());
        }
        this.assertReliability(msg);
    }

    void addAcknowledgements(Destination destination, RMProperties rmpsOut, Identifier inSeqId, AttributedURIType to) {
        for (DestinationSequence seq : destination.getAllSequences()) {
            if (!seq.sendAcknowledgement()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("no need to add acknowledgements for sequence " + seq.getIdentifier().getValue());
                continue;
            }
            String address = seq.getAcksTo().getAddress().getValue();
            if (!to.getValue().equals(address)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequences acksTo address (" + address + ") does not match to address (" + to.getValue() + ")");
                continue;
            }
            if (RMUtils.getAddressingConstants().getAnonymousURI().equals(address) && !AbstractSequence.identifierEquals(seq.getIdentifier(), inSeqId)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("sequence identifier does not match inbound sequence identifier");
                continue;
            }
            rmpsOut.addAck(seq);
        }
        if (LOG.isLoggable(Level.FINE)) {
            Collection<SequenceAcknowledgement> acks = rmpsOut.getAcks();
            if (null == acks) {
                LOG.fine("No acknowledgements added.");
            } else {
                LOG.fine("Added " + acks.size() + " acknowledgements.");
            }
        }
    }

    private void addRetransmissionInterceptor(Message msg) {
        RetransmissionInterceptor ri = new RetransmissionInterceptor();
        ri.setManager(this.getManager());
        msg.getInterceptorChain().add(ri);
        LOG.fine("Added RetransmissionInterceptor to chain.");
        RetransmissionQueue queue = this.getManager().getRetransmissionQueue();
        if (queue != null) {
            queue.start();
        }
    }

    boolean isRuntimeFault(Message message) {
        FaultMode mode = MessageUtils.getFaultMode(message);
        if (null == mode) {
            return false;
        }
        return FaultMode.CHECKED_APPLICATION_FAULT != mode;
    }

    private static void setAction(AddressingProperties maps, String action) {
        AttributedURIType actionURI = new AttributedURIType();
        actionURI.setValue(action);
        maps.setAction(actionURI);
    }
}

