/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.DatatypeFactory;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.v200702.AcceptType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Expires;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.OfferType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;

public class Servant
implements Invoker {
    private static final Logger LOG = LogUtils.getL7dLogger(Servant.class);
    private RMEndpoint reliableEndpoint;
    private Identifier unattachedIdentifier;

    Servant(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    @Override
    public Object invoke(Exchange exchange, Object o) {
        LOG.fine("Invoking on RM Endpoint");
        ProtocolVariation protocol = RMContextUtils.getProtocolVariation(exchange.getInMessage());
        OperationInfo oi = exchange.get(OperationInfo.class);
        if (null == oi) {
            LOG.fine("No operation info.");
            return null;
        }
        if (RM10Constants.INSTANCE.getCreateSequenceOperationName().equals(oi.getName()) || RM11Constants.INSTANCE.getCreateSequenceOperationName().equals(oi.getName()) || RM10Constants.INSTANCE.getCreateSequenceOnewayOperationName().equals(oi.getName()) || RM11Constants.INSTANCE.getCreateSequenceOnewayOperationName().equals(oi.getName())) {
            try {
                return Collections.singletonList(this.createSequence(exchange.getInMessage()));
            }
            catch (RuntimeException ex) {
                Binding b;
                LOG.log(Level.WARNING, "Sequence creation rejected", ex);
                SequenceFault sf = new SequenceFaultFactory(protocol.getConstants()).createCreateSequenceRefusedFault();
                Endpoint e = exchange.get(Endpoint.class);
                Binding binding = b = null == e ? null : e.getBinding();
                if (null != b) {
                    RMManager m = this.reliableEndpoint.getManager();
                    LOG.fine("Manager: " + m);
                    BindingFaultFactory bff = m.getBindingFaultFactory(b);
                    Fault f = bff.createFault(sf, exchange.getInMessage());
                    LogUtils.log(LOG, Level.WARNING, "SEQ_FAULT_MSG", bff.toString(f));
                    throw f;
                }
                throw new Fault(sf);
            }
        }
        if (RM10Constants.INSTANCE.getCreateSequenceResponseOnewayOperationName().equals(oi.getName()) || RM11Constants.INSTANCE.getCreateSequenceResponseOnewayOperationName().equals(oi.getName())) {
            EncoderDecoder codec = protocol.getCodec();
            CreateSequenceResponseType createResponse = codec.convertReceivedCreateSequenceResponse(this.getParameter(exchange.getInMessage()));
            this.createSequenceResponse(createResponse, protocol);
        } else if (RM10Constants.INSTANCE.getTerminateSequenceOperationName().equals(oi.getName()) || RM11Constants.INSTANCE.getTerminateSequenceOperationName().equals(oi.getName())) {
            Object tsr = this.terminateSequence(exchange.getInMessage());
            if (tsr != null) {
                return Collections.singletonList(tsr);
            }
        } else if (RM11Constants.INSTANCE.getCloseSequenceOperationName().equals(oi.getName())) {
            return Collections.singletonList(this.closeSequence(exchange.getInMessage()));
        }
        return null;
    }

    Object createSequence(Message message) {
        OfferType offer;
        Expires ex;
        LOG.fine("Creating sequence");
        ProtocolVariation protocol = RMContextUtils.getProtocolVariation(message);
        AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
        Message outMessage = message.getExchange().getOutMessage();
        if (null != outMessage) {
            RMContextUtils.storeMAPs(maps, outMessage, false, false);
        }
        EncoderDecoder codec = protocol.getCodec();
        CreateSequenceType create = codec.convertReceivedCreateSequence(this.getParameter(message));
        Destination destination = this.reliableEndpoint.getDestination();
        CreateSequenceResponseType createResponse = new CreateSequenceResponseType();
        createResponse.setIdentifier(destination.generateSequenceIdentifier());
        DestinationPolicyType dp = this.reliableEndpoint.getManager().getDestinationPolicy();
        if (dp.getMaxSequences() > 0 && destination.getProcessingSequenceCount() >= dp.getMaxSequences()) {
            throw new RuntimeException("Sequence creation refused");
        }
        Duration supportedDuration = dp.getSequenceExpiration();
        if (null == supportedDuration) {
            supportedDuration = DatatypeFactory.PT0S;
        }
        if (null != (ex = create.getExpires())) {
            Duration effectiveDuration = ex.getValue();
            if (DatatypeFactory.PT0S.equals(effectiveDuration) || !DatatypeFactory.PT0S.equals(supportedDuration) && supportedDuration.isShorterThan(effectiveDuration)) {
                effectiveDuration = supportedDuration;
            }
            ex = new Expires();
            ex.setValue(effectiveDuration);
            createResponse.setExpires(ex);
        }
        if (null != (offer = create.getOffer())) {
            AcceptType accept = new AcceptType();
            if (dp.isAcceptOffers()) {
                Source source = this.reliableEndpoint.getSource();
                LOG.fine("Accepting inbound sequence offer");
                accept.setAcksTo(RMUtils.createReference(maps.getTo().getValue()));
                SourceSequence seq = new SourceSequence(offer.getIdentifier(), null, createResponse.getIdentifier(), protocol);
                seq.setExpires(offer.getExpires());
                seq.setTarget(create.getAcksTo());
                source.addSequence(seq);
                source.setCurrent(createResponse.getIdentifier(), seq);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Making offered sequence the current sequence for responses to " + createResponse.getIdentifier().getValue());
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Refusing inbound sequence offer");
                }
                accept.setAcksTo(RMUtils.createNoneReference());
            }
            createResponse.setAccept(accept);
        }
        DestinationSequence seq = new DestinationSequence(createResponse.getIdentifier(), create.getAcksTo(), destination, protocol);
        seq.setCorrelationID(maps.getMessageID().getValue());
        destination.addSequence(seq);
        LOG.fine("returning " + createResponse);
        return codec.convertToSend(createResponse);
    }

    public void createSequenceResponse(CreateSequenceResponseType createResponse, ProtocolVariation protocol) {
        LOG.fine("Creating sequence response");
        SourceSequence seq = new SourceSequence(createResponse.getIdentifier(), protocol);
        seq.setExpires(createResponse.getExpires());
        Source source = this.reliableEndpoint.getSource();
        source.addSequence(seq);
        source.setCurrent(this.clearUnattachedIdentifier(), seq);
        Identifier offeredId = this.reliableEndpoint.getProxy().getOfferedIdentifier();
        if (null != offeredId) {
            AcceptType accept = createResponse.getAccept();
            assert (null != accept);
            Destination dest = this.reliableEndpoint.getDestination();
            String address = accept.getAcksTo().getAddress().getValue();
            if (!RMUtils.getAddressingConstants().getNoneURI().equals(address)) {
                DestinationSequence ds = new DestinationSequence(offeredId, accept.getAcksTo(), dest, protocol);
                dest.addSequence(ds);
            }
        }
    }

    public Object terminateSequence(Message message) {
        LOG.fine("Terminating sequence");
        ProtocolVariation protocol = RMContextUtils.getProtocolVariation(message);
        EncoderDecoder codec = protocol.getCodec();
        TerminateSequenceType terminate = codec.convertReceivedTerminateSequence(this.getParameter(message));
        Destination destination = this.reliableEndpoint.getDestination();
        Identifier sid = terminate.getIdentifier();
        DestinationSequence terminatedSeq = destination.getSequence(sid);
        if (null == terminatedSeq) {
            LOG.severe("No such sequence.");
            return null;
        }
        destination.removeSequence(terminatedSeq);
        Source source = this.reliableEndpoint.getSource();
        for (SourceSequence outboundSeq : source.getAllSequences()) {
            if (!outboundSeq.offeredBy(sid) || outboundSeq.isLastMessage()) continue;
            if (outboundSeq.getCurrentMessageNr() != 0L) break;
            source.removeSequence(outboundSeq);
            break;
        }
        TerminateSequenceResponseType terminateResponse = null;
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(protocol.getWSRMNamespace())) {
            AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
            Message outMessage = message.getExchange().getOutMessage();
            if (null == outMessage) {
                outMessage = ContextUtils.createMessage(message.getExchange());
                message.getExchange().setOutMessage(outMessage);
            }
            if (null != outMessage) {
                RMContextUtils.storeMAPs(maps, outMessage, false, false);
            }
            terminateResponse = new TerminateSequenceResponseType();
            terminateResponse.setIdentifier(sid);
        }
        return terminateResponse;
    }

    public Object closeSequence(Message message) {
        LOG.fine("Closing sequence");
        CloseSequenceType close = (CloseSequenceType)this.getParameter(message);
        Destination destination = this.reliableEndpoint.getDestination();
        Identifier sid = close.getIdentifier();
        DestinationSequence closedSeq = destination.getSequence(sid);
        if (null == closedSeq) {
            LOG.severe("No such sequence.");
            return null;
        }
        closedSeq.scheduleImmediateAcknowledgement();
        closedSeq.setLastMessageNumber(close.getLastMsgNumber());
        CloseSequenceResponseType closeResponse = new CloseSequenceResponseType();
        closeResponse.setIdentifier(close.getIdentifier());
        AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
        Message outMessage = message.getExchange().getOutMessage();
        if (null == outMessage) {
            outMessage = ContextUtils.createMessage(message.getExchange());
            message.getExchange().setOutMessage(outMessage);
        }
        if (null != outMessage) {
            RMContextUtils.storeMAPs(maps, outMessage, false, false);
        }
        return closeResponse;
    }

    Object getParameter(Message message) {
        List resList = null;
        if (message != null) {
            resList = message.getContent(List.class);
        }
        if (resList != null) {
            return resList.get(0);
        }
        return null;
    }

    Identifier clearUnattachedIdentifier() {
        Identifier ret = this.unattachedIdentifier;
        this.unattachedIdentifier = null;
        return ret;
    }

    void setUnattachedIdentifier(Identifier i) {
        this.unattachedIdentifier = i;
    }
}

