/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RMSoapOutInterceptor
extends AbstractSoapInterceptor {
    protected static JAXBContext jaxbContext;
    private static final Set<QName> HEADERS;
    private static final Logger LOG;

    public RMSoapOutInterceptor() {
        super("pre-protocol");
        this.addAfter(MAPCodec.class.getName());
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        this.encode(message);
    }

    void encode(SoapMessage message) {
        Exception ex;
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, true);
        if (null != rmps) {
            RMSoapOutInterceptor.encode(message, rmps);
        } else if (MessageUtils.isFault(message) && (ex = message.getContent(Exception.class)) instanceof SoapFault && ex.getCause() instanceof SequenceFault) {
            RMSoapOutInterceptor.encodeFault(message, (SequenceFault)ex.getCause());
        }
    }

    public static void encode(SoapMessage message, RMProperties rmps) {
        if (null == rmps) {
            return;
        }
        LOG.log(Level.FINE, "encoding RMPs in SOAP headers");
        try {
            AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, true);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI());
            Element header = protocol.getCodec().buildHeaders(rmps, message.getVersion().getHeader());
            if (header != null) {
                Node node = header.getFirstChild();
                if (node != null && MessageUtils.isPartialResponse(message)) {
                    message.put(Message.RESPONSE_CODE, (Object)200);
                }
                while (node != null) {
                    Header holder = null;
                    if (node.getLocalName().equals("Sequence")) {
                        holder = new SoapHeader(new QName(node.getNamespaceURI(), node.getLocalName()), node);
                        ((SoapHeader)holder).setMustUnderstand(true);
                    } else {
                        holder = new Header(new QName(node.getNamespaceURI(), node.getLocalName()), node);
                    }
                    message.getHeaders().add(holder);
                    node = node.getNextSibling();
                }
            }
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    public static void encodeFault(SoapMessage message, SequenceFault sf) {
        LOG.log(Level.FINE, "Encoding SequenceFault in SOAP header");
        try {
            Message inmsg = message.getExchange().getInMessage();
            RMProperties rmps = RMContextUtils.retrieveRMProperties(inmsg, false);
            AddressingProperties maps = RMContextUtils.retrieveMAPs(inmsg, false, false);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI());
            Element header = protocol.getCodec().buildHeaderFault(sf, message.getVersion().getHeader());
            Node node = header.getFirstChild();
            if (node instanceof Element) {
                Attr attr = header.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
                attr.setValue(rmps.getNamespaceURI());
                ((Element)node).setAttributeNodeNS(attr);
            }
            List<Header> headers = message.getHeaders();
            headers.add(new Header(new QName(node.getNamespaceURI(), node.getLocalName()), node));
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.addAll(RM10Constants.HEADERS);
        set.addAll(RM11Constants.HEADERS);
        HEADERS = set;
        LOG = LogUtils.getL7dLogger(RMSoapOutInterceptor.class);
    }
}

