/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractTokenInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.processor.BinarySecurityTokenProcessor;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.wss4j.policy.model.AbstractToken;
import org.w3c.dom.Element;

public class KerberosTokenInterceptor
extends AbstractTokenInterceptor {
    @Override
    protected void processToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement(el);
        while (child != null) {
            if ("BinarySecurityToken".equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                try {
                    List<WSSecurityEngineResult> bstResults = this.processToken(child, message);
                    if (bstResults != null) {
                        List results = CastUtils.cast((List)message.get("RECV_RESULTS"));
                        if (results == null) {
                            results = new ArrayList();
                            message.put("RECV_RESULTS", (Object)results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, bstResults);
                        results.add(0, rResult);
                        this.assertTokens(message, "KerberosToken", false);
                        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
                        this.assertPolicy(aim, "WssKerberosV5ApReqToken11");
                        this.assertPolicy(aim, "WssGssKerberosV5ApReqToken11");
                        Principal principal = (Principal)bstResults.get(0).get((Object)"principal");
                        message.put("wss4j.principal.result", (Object)principal);
                        SecurityContext sc = message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            message.put(SecurityContext.class, new DefaultSecurityContext(principal, null));
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault(ex);
                }
            }
            child = DOMUtils.getNextElement(child);
        }
    }

    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){

            public CallbackHandler getCallbackHandler() {
                return KerberosTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = "ws-security.bst.validator";
                Object o = message.getContextualProperty(key);
                try {
                    if (o instanceof Validator) {
                        return (Validator)o;
                    }
                    if (o instanceof Class) {
                        return (Validator)((Class)o).newInstance();
                    }
                    if (o instanceof String) {
                        return (Validator)ClassLoaderUtils.loadClass(o.toString(), KerberosTokenInterceptor.class).newInstance();
                    }
                }
                catch (RuntimeException t) {
                    throw t;
                }
                catch (Exception ex) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
                }
                return super.getValidator(qName);
            }
        };
        data.setWssConfig(WSSConfig.getNewInstance());
        BinarySecurityTokenProcessor p = new BinarySecurityTokenProcessor();
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return results;
    }

    @Override
    protected AbstractToken assertTokens(SoapMessage message) {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        this.assertPolicy(aim, "WssKerberosV5ApReqToken11");
        this.assertPolicy(aim, "WssGssKerberosV5ApReqToken11");
        return this.assertTokens(message, "KerberosToken", true);
    }

    @Override
    protected void addToken(SoapMessage message) {
        SecurityToken securityToken = this.getSecurityToken(message);
        if (securityToken == null || securityToken.getToken() == null) {
            return;
        }
        this.assertTokens(message);
        Header h = this.findSecurityHeader(message, true);
        Element el = (Element)h.getObject();
        el.appendChild(el.getOwnerDocument().importNode(securityToken.getToken(), true));
    }

    private SecurityToken getSecurityToken(SoapMessage message) {
        TokenStore tokenStore = this.getTokenStore(message);
        if (tokenStore == null) {
            return null;
        }
        String id = (String)message.getContextualProperty("ws-security.token.id");
        if (id != null) {
            return tokenStore.getToken(id);
        }
        return null;
    }
}

