/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.AlgorithmSuiteTranslater;
import org.apache.cxf.ws.security.wss4j.CryptoCoverageUtil;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSupportingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AlgorithmSuitePolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AsymmetricBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.ConcreteSupportingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.EncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.EndorsingEncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.EndorsingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.LayoutPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SamlTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SecurityContextTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedEncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedEndorsingEncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedEndorsingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SymmetricBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TransportBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.UsernameTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.WSS11PolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.X509TokenPolicyValidator;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.JasyptPasswordEncryptor;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.SP13Constants;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.Attachments;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.RequiredElements;
import org.apache.wss4j.policy.model.RequiredParts;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.model.Wss11;
import org.apache.wss4j.policy.model.XPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyBasedWSS4JInInterceptor
extends WSS4JInInterceptor {
    public static final PolicyBasedWSS4JInInterceptor INSTANCE = new PolicyBasedWSS4JInInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JInInterceptor.class);

    public PolicyBasedWSS4JInInterceptor() {
        super(true);
    }

    @Override
    public void handleMessage(SoapMessage msg) throws Fault {
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        boolean enableStax = MessageUtils.isTrue(msg.getContextualProperty("ws-security.enable.streaming"));
        if (aim != null && !enableStax) {
            super.handleMessage(msg);
        }
    }

    private static Properties getProps(Object o, URL propsURL, SoapMessage message) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (propsURL != null) {
            try {
                properties = new Properties();
                InputStream ins = propsURL.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                properties = null;
            }
        }
        return properties;
    }

    private URL getPropertiesFileURL(Object o, SoapMessage message) {
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
            url = rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)o, AbstractWSS4JInterceptor.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    private void handleWSS11(AssertionInfoMap aim, SoapMessage message) {
        if (this.isRequestor(message)) {
            message.put("enableSignatureConfirmation", (Object)"false");
            Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "Wss11");
            if (!ais.isEmpty()) {
                for (AssertionInfo ai : ais) {
                    Wss11 wss11 = (Wss11)ai.getAssertion();
                    if (!wss11.isRequireSignatureConfirmation()) continue;
                    message.put("enableSignatureConfirmation", (Object)"true");
                    break;
                }
            }
        }
    }

    private String addToAction(String action, String val, boolean pre) {
        if (action.contains(val)) {
            return action;
        }
        if (pre) {
            return val + " " + action;
        }
        return action + " " + val;
    }

    private boolean assertPolicy(AssertionInfoMap aim, QName name) {
        Collection<AssertionInfo> ais = aim.getAssertionInfo(name);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    private boolean assertPolicy(AssertionInfoMap aim, String localname) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, localname);
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    private Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
            HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
            if (sp11Ais != null) {
                ais.addAll(sp11Ais);
            }
            if (sp12Ais != null) {
                ais.addAll(sp12Ais);
            }
            return ais;
        }
        return Collections.emptySet();
    }

    private String checkAsymmetricBinding(AssertionInfoMap aim, String action, SoapMessage message, RequestData data) throws WSSecurityException {
        Object e;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
        if (ais.isEmpty()) {
            return action;
        }
        action = this.addToAction(action, "Signature", true);
        action = this.addToAction(action, "Encrypt", true);
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, data);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, data);
        if (signCrypto != null) {
            message.put("decryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        return action;
    }

    private String checkDefaultBinding(AssertionInfoMap aim, String action, SoapMessage message, RequestData data) throws WSSecurityException {
        Object e;
        action = this.addToAction(action, "Signature", true);
        action = this.addToAction(action, "Encrypt", true);
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, data);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, data);
        if (signCrypto != null) {
            message.put("decryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        return action;
    }

    @Override
    protected boolean isNonceCacheRequired(List<Integer> actions, SoapMessage msg) {
        Collection<AssertionInfo> ais;
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        return aim != null && !(ais = this.getAllAssertionsByLocalname(aim, "UsernameToken")).isEmpty();
    }

    @Override
    protected boolean isTimestampCacheRequired(List<Integer> actions, SoapMessage msg) {
        Collection<AssertionInfo> ais;
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        return aim != null && !(ais = this.getAllAssertionsByLocalname(aim, "IncludeTimestamp")).isEmpty();
    }

    @Override
    protected boolean isSamlCacheRequired(List<Integer> actions, SoapMessage msg) {
        Collection<AssertionInfo> ais;
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        return aim != null && !(ais = this.getAllAssertionsByLocalname(aim, "SamlToken")).isEmpty();
    }

    private void checkUsernameToken(AssertionInfoMap aim, SoapMessage message) throws WSSecurityException {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "UsernameToken");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                UsernameToken policy = (UsernameToken)ai.getAssertion();
                if (policy.getPasswordType() != UsernameToken.PasswordType.NoPassword) continue;
                message.put("allowUsernameTokenNoPassword", (Object)"true");
            }
        }
    }

    private String checkSymmetricBinding(AssertionInfoMap aim, String action, SoapMessage message, RequestData data) throws WSSecurityException {
        Object e;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SymmetricBinding");
        if (ais.isEmpty()) {
            return action;
        }
        action = this.addToAction(action, "Signature", true);
        action = this.addToAction(action, "Encrypt", true);
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, data);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, data);
        if (this.isRequestor(message)) {
            Crypto crypto = encrCrypto;
            if (crypto == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("signatureVerificationPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = signCrypto) == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("decryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        } else {
            Crypto crypto = signCrypto;
            if (crypto == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("signatureVerificationPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = encrCrypto) == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("decryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getEncryptionCrypto(Object e, SoapMessage message, RequestData requestData) throws WSSecurityException {
        Crypto encrCrypto = null;
        if (e instanceof Crypto) {
            encrCrypto = (Crypto)e;
        } else if (e != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(e, message);
            Properties props = PolicyBasedWSS4JInInterceptor.getProps(e, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Encryption properties: " + e);
                Exception ex = new Exception("Cannot find Crypto Encryption properties: " + e);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            PasswordEncryptor passwordEncryptor = this.getPasswordEncryptor(message, requestData);
            encrCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)passwordEncryptor);
            EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.encryption.crypto", encrCrypto);
            }
        }
        return encrCrypto;
    }

    private PasswordEncryptor getPasswordEncryptor(SoapMessage soapMessage, RequestData requestData) {
        PasswordEncryptor passwordEncryptor = (PasswordEncryptor)soapMessage.getContextualProperty("ws-security.password.encryptor.instance");
        if (passwordEncryptor != null) {
            return passwordEncryptor;
        }
        if (requestData.getPasswordEncryptor() != null) {
            return requestData.getPasswordEncryptor();
        }
        CallbackHandler callbackHandler = requestData.getCallbackHandler();
        if (callbackHandler != null) {
            return new JasyptPasswordEncryptor(callbackHandler);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getSignatureCrypto(Object s, SoapMessage message, RequestData requestData) throws WSSecurityException {
        Crypto signCrypto = null;
        if (s instanceof Crypto) {
            signCrypto = (Crypto)s;
        } else if (s != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(s, message);
            Properties props = PolicyBasedWSS4JInInterceptor.getProps(s, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Signature properties: " + s);
                Exception ex = new Exception("Cannot find Crypto Signature properties: " + s);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            PasswordEncryptor passwordEncryptor = this.getPasswordEncryptor(message, requestData);
            signCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)passwordEncryptor);
            EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.signature.crypto", signCrypto);
            }
        }
        return signCrypto;
    }

    private boolean assertXPathTokens(AssertionInfoMap aim, String name, Collection<WSDataRef> refs, Element soapEnvelope, CryptoCoverageUtil.CoverageType type, CryptoCoverageUtil.CoverageScope scope, javax.xml.xpath.XPath xpath) throws SOAPException {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, name);
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                RequiredElements elements = (RequiredElements)ai.getAssertion();
                if (elements == null || elements.getXPaths() == null || elements.getXPaths().isEmpty()) continue;
                ArrayList<String> expressions = new ArrayList<String>();
                for (XPath xPath : elements.getXPaths()) {
                    expressions.add(xPath.getXPath());
                }
                if (((XPath)elements.getXPaths().get(0)).getPrefixNamespaceMap() != null) {
                    xpath.setNamespaceContext(new MapNamespaceContext(((XPath)elements.getXPaths().get(0)).getPrefixNamespaceMap()));
                }
                try {
                    CryptoCoverageUtil.checkCoverage(soapEnvelope, refs, xpath, expressions, type, scope);
                }
                catch (WSSecurityException e) {
                    ai.setNotAsserted("No " + (Object)((Object)type) + " element found matching one of the XPaths " + Arrays.toString(expressions.toArray()));
                }
            }
        }
        return true;
    }

    private boolean assertTokens(AssertionInfoMap aim, String name, Collection<WSDataRef> signed, SoapMessage msg, Element soapHeader, Element soapBody, CryptoCoverageUtil.CoverageType type) throws SOAPException {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, name);
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                SignedParts p = (SignedParts)ai.getAssertion();
                if (p.isBody()) {
                    try {
                        if (CryptoCoverageUtil.CoverageType.SIGNED.equals((Object)type)) {
                            CryptoCoverageUtil.checkBodyCoverage(soapBody, signed, type, CryptoCoverageUtil.CoverageScope.ELEMENT);
                        } else {
                            CryptoCoverageUtil.checkBodyCoverage(soapBody, signed, type, CryptoCoverageUtil.CoverageScope.CONTENT);
                        }
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted(msg.getVersion().getBody() + " not " + (Object)((Object)type));
                        continue;
                    }
                }
                for (Header h : p.getHeaders()) {
                    try {
                        CryptoCoverageUtil.checkHeaderCoverage(soapHeader, signed, h.getNamespace(), h.getName(), type, CryptoCoverageUtil.CoverageScope.ELEMENT);
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted(h.getNamespace() + ":" + h.getName() + " not + " + (Object)((Object)type));
                    }
                }
                Attachments attachments = p.getAttachments();
                if (attachments == null) continue;
                try {
                    CryptoCoverageUtil.CoverageScope scope = CryptoCoverageUtil.CoverageScope.ELEMENT;
                    if (attachments.isContentSignatureTransform()) {
                        scope = CryptoCoverageUtil.CoverageScope.CONTENT;
                    }
                    CryptoCoverageUtil.checkAttachmentsCoverage(msg.getAttachments(), signed, type, scope);
                }
                catch (WSSecurityException e) {
                    ai.setNotAsserted("An attachment was not signed/encrypted");
                }
            }
        }
        return true;
    }

    @Override
    protected void setAlgorithmSuites(SoapMessage message, RequestData data) throws WSSecurityException {
        AlgorithmSuiteTranslater translater = new AlgorithmSuiteTranslater();
        translater.translateAlgorithmSuites(message.get(AssertionInfoMap.class), data);
        String asymSignatureAlgorithm = (String)message.getContextualProperty("ws-security.asymmetric.signature.algorithm");
        if (asymSignatureAlgorithm != null && data.getAlgorithmSuite() != null) {
            data.getAlgorithmSuite().getSignatureMethods().clear();
            data.getAlgorithmSuite().getSignatureMethods().add(asymSignatureAlgorithm);
        }
    }

    @Override
    protected void computeAction(SoapMessage message, RequestData data) throws WSSecurityException {
        AssertionInfoMap aim;
        String action = this.getString("action", message);
        if (action == null) {
            action = "";
        }
        if ((aim = message.get(AssertionInfoMap.class)) != null) {
            Collection algorithmSuites;
            String asymSignatureAlgorithm;
            this.handleWSS11(aim, message);
            action = this.checkAsymmetricBinding(aim, action, message, data);
            action = this.checkSymmetricBinding(aim, action, message, data);
            Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
            if ("".equals(action) || ais != null && !ais.isEmpty()) {
                action = this.checkDefaultBinding(aim, action, message, data);
            }
            if ((asymSignatureAlgorithm = (String)message.getContextualProperty("ws-security.asymmetric.signature.algorithm")) != null && (algorithmSuites = (Collection)aim.get(SP12Constants.ALGORITHM_SUITE)) != null && !algorithmSuites.isEmpty()) {
                for (AssertionInfo algorithmSuite : algorithmSuites) {
                    AlgorithmSuite algSuite = (AlgorithmSuite)algorithmSuite.getAssertion();
                    algSuite.setAsymmetricSignature(asymSignatureAlgorithm);
                }
            }
            this.checkUsernameToken(aim, message);
            this.assertPolicy(aim, "KeyValueToken");
            this.assertPolicy(aim, "RsaKeyValue");
            this.assertPolicy(aim, "RequireIssuerSerialReference");
            this.assertPolicy(aim, "RequireThumbprintReference");
            this.assertPolicy(aim, "RequireKeyIdentifierReference");
            this.assertPolicy(aim, "RequireEmbeddedTokenReference");
            this.assertPolicy(aim, "RequireInternalReference");
            this.assertPolicy(aim, "Wss10");
            this.assertPolicy(aim, "MustSupportRefKeyIdentifier");
            this.assertPolicy(aim, "MustSupportRefIssuerSerial");
            this.assertPolicy(aim, "MustSupportRefExternalURI");
            this.assertPolicy(aim, "MustSupportRefEmbeddedToken");
            this.assertPolicy(aim, "Trust10");
            this.assertPolicy(aim, "MustSupportClientChallenge");
            this.assertPolicy(aim, "MustSupportServerChallenge");
            this.assertPolicy(aim, "RequireClientEntropy");
            this.assertPolicy(aim, "RequireServerEntropy");
            this.assertPolicy(aim, "MustSupportIssuedTokens");
            this.assertPolicy(aim, "Trust13");
            this.assertPolicy(aim, SP12Constants.REQUIRE_REQUEST_SECURITY_TOKEN_COLLECTION);
            this.assertPolicy(aim, SP12Constants.REQUIRE_APPLIES_TO);
            this.assertPolicy(aim, SP13Constants.SCOPE_POLICY_15);
            this.assertPolicy(aim, SP13Constants.MUST_SUPPORT_INTERACTIVE_CHALLENGE);
            message.put("action", (Object)action.trim());
        }
    }

    @Override
    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> results, boolean utWithCallbacks) throws SOAPException, XMLStreamException, WSSecurityException {
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        HashSet<WSDataRef> signed = new HashSet<WSDataRef>();
        HashSet<WSDataRef> encrypted = new HashSet<WSDataRef>();
        ArrayList<Integer> actions = new ArrayList<Integer>(2);
        actions.add(2);
        actions.add(64);
        List signedResults = WSSecurityUtil.fetchAllActionResults(results, actions);
        for (WSSecurityEngineResult result : signedResults) {
            List<WSDataRef> sl = CastUtils.cast((List)result.get((Object)"data-ref-uris"));
            if (sl == null) continue;
            for (WSDataRef r : sl) {
                signed.add(r);
            }
        }
        List encryptResults = WSSecurityUtil.fetchAllActionResults(results, (int)4);
        for (WSSecurityEngineResult result : encryptResults) {
            List<WSDataRef> sl = CastUtils.cast((List)result.get((Object)"data-ref-uris"));
            if (sl == null) continue;
            for (WSDataRef r : sl) {
                encrypted.add(r);
            }
        }
        if (!this.checkSignedEncryptedCoverage(aim, msg, soapHeader, soapBody, signed, encrypted)) {
            LOG.fine("Incoming request failed signed-encrypted policy validation");
        }
        if (!this.checkTokenCoverage(aim, msg, soapBody, results, signedResults)) {
            LOG.fine("Incoming request failed token policy validation");
        }
        if (!this.checkBindingCoverage(aim, msg, soapBody, results, signedResults, encryptResults)) {
            LOG.fine("Incoming request failed binding policy validation");
        }
        if (!this.checkSupportingTokenCoverage(aim, msg, results, signedResults, encryptResults, utWithCallbacks)) {
            LOG.fine("Incoming request failed supporting token policy validation");
        }
        super.doResults(msg, actor, soapHeader, soapBody, results, utWithCallbacks);
    }

    private boolean checkSignedEncryptedCoverage(AssertionInfoMap aim, SoapMessage msg, Element soapHeader, Element soapBody, Collection<WSDataRef> signed, Collection<WSDataRef> encrypted) throws SOAPException {
        CryptoCoverageUtil.reconcileEncryptedSignedRefs(signed, encrypted);
        boolean check = true;
        if (!this.isTransportBinding(aim)) {
            check &= this.assertTokens(aim, "SignedParts", signed, msg, soapHeader, soapBody, CryptoCoverageUtil.CoverageType.SIGNED);
            check &= this.assertTokens(aim, "EncryptedParts", encrypted, msg, soapHeader, soapBody, CryptoCoverageUtil.CoverageType.ENCRYPTED);
        }
        Element soapEnvelope = soapHeader.getOwnerDocument().getDocumentElement();
        if (this.containsXPathPolicy(aim)) {
            XPathFactory factory = XPathFactory.newInstance();
            javax.xml.xpath.XPath xpath = factory.newXPath();
            check &= this.assertXPathTokens(aim, "SignedElements", signed, soapEnvelope, CryptoCoverageUtil.CoverageType.SIGNED, CryptoCoverageUtil.CoverageScope.ELEMENT, xpath);
            check &= this.assertXPathTokens(aim, "EncryptedElements", encrypted, soapEnvelope, CryptoCoverageUtil.CoverageType.ENCRYPTED, CryptoCoverageUtil.CoverageScope.ELEMENT, xpath);
            check &= this.assertXPathTokens(aim, "ContentEncryptedElements", encrypted, soapEnvelope, CryptoCoverageUtil.CoverageType.ENCRYPTED, CryptoCoverageUtil.CoverageScope.CONTENT, xpath);
        }
        return check &= this.assertHeadersExists(aim, msg, soapHeader);
    }

    private boolean checkTokenCoverage(AssertionInfoMap aim, SoapMessage msg, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        boolean check = true;
        X509TokenPolicyValidator x509Validator = new X509TokenPolicyValidator();
        check &= x509Validator.validatePolicy(aim, msg, soapBody, results, signedResults);
        UsernameTokenPolicyValidator utValidator = new UsernameTokenPolicyValidator();
        check &= utValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        SamlTokenPolicyValidator samlValidator = new SamlTokenPolicyValidator();
        check &= samlValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        SecurityContextTokenPolicyValidator sctValidator = new SecurityContextTokenPolicyValidator();
        check &= sctValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        WSS11PolicyValidator wss11Validator = new WSS11PolicyValidator();
        return check &= wss11Validator.validatePolicy(aim, msg, soapBody, results, signedResults);
    }

    private boolean checkBindingCoverage(AssertionInfoMap aim, SoapMessage msg, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        boolean check = true;
        TransportBindingPolicyValidator transportValidator = new TransportBindingPolicyValidator();
        check &= transportValidator.validatePolicy(aim, msg, soapBody, results, signedResults, encryptedResults);
        SymmetricBindingPolicyValidator symmetricValidator = new SymmetricBindingPolicyValidator();
        check &= symmetricValidator.validatePolicy(aim, msg, soapBody, results, signedResults, encryptedResults);
        AsymmetricBindingPolicyValidator asymmetricValidator = new AsymmetricBindingPolicyValidator();
        check &= asymmetricValidator.validatePolicy(aim, msg, soapBody, results, signedResults, encryptedResults);
        AlgorithmSuitePolicyValidator algorithmSuiteValidator = new AlgorithmSuitePolicyValidator();
        check &= algorithmSuiteValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        LayoutPolicyValidator layoutValidator = new LayoutPolicyValidator();
        return check &= layoutValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
    }

    private boolean checkSupportingTokenCoverage(AssertionInfoMap aim, SoapMessage msg, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults, boolean utWithCallbacks) {
        ArrayList<Integer> utActions = new ArrayList<Integer>(2);
        utActions.add(1);
        utActions.add(8192);
        List utResults = WSSecurityUtil.fetchAllActionResults(results, utActions);
        ArrayList<Integer> samlActions = new ArrayList<Integer>(2);
        samlActions.add(16);
        samlActions.add(8);
        List samlResults = WSSecurityUtil.fetchAllActionResults(results, samlActions);
        WSSecurityEngineResult tsResult = WSSecurityUtil.fetchActionResult(results, (int)32);
        Element timestamp = null;
        if (tsResult != null) {
            Timestamp ts = (Timestamp)tsResult.get((Object)"timestamp");
            timestamp = ts.getElement();
        }
        boolean check = true;
        AbstractSupportingTokenPolicyValidator validator = new ConcreteSupportingTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new EndorsingTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedEndorsingTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedEncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new EncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new EndorsingEncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedEndorsingEncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        return check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
    }

    private boolean assertHeadersExists(AssertionInfoMap aim, SoapMessage msg, Node header) throws SOAPException {
        RequiredParts rp;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "RequiredParts");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                rp = (RequiredParts)ai.getAssertion();
                ai.setAsserted(true);
                for (Header h : rp.getHeaders()) {
                    QName qName = new QName(h.getNamespace(), h.getName());
                    if (header != null && DOMUtils.getFirstChildWithName((Element)header, qName) != null) continue;
                    ai.setNotAsserted("No header element of name " + qName + " found.");
                }
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "RequiredElements")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                rp = (RequiredElements)ai.getAssertion();
                ai.setAsserted(true);
                if (rp == null || rp.getXPaths() == null || rp.getXPaths().isEmpty()) continue;
                XPathFactory factory = XPathFactory.newInstance();
                for (XPath xPath : rp.getXPaths()) {
                    Map namespaces = xPath.getPrefixNamespaceMap();
                    String expression = xPath.getXPath();
                    javax.xml.xpath.XPath xpath = factory.newXPath();
                    if (namespaces != null) {
                        xpath.setNamespaceContext(new MapNamespaceContext(namespaces));
                    }
                    try {
                        NodeList list = (NodeList)xpath.evaluate(expression, header, XPathConstants.NODESET);
                        if (list.getLength() != 0) continue;
                        ai.setNotAsserted("No header element matching XPath " + expression + " found.");
                    }
                    catch (XPathExpressionException e) {
                        ai.setNotAsserted("Invalid XPath expression " + expression + " " + e.getMessage());
                    }
                }
            }
        }
        return true;
    }

    private boolean isTransportBinding(AssertionInfoMap aim) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "TransportBinding");
        if (ais.size() > 0) {
            ais = this.getAllAssertionsByLocalname(aim, "SymmetricBinding");
            if (ais.size() > 0) {
                return false;
            }
            ais = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
            return ais.size() <= 0;
        }
        return false;
    }

    private boolean containsXPathPolicy(AssertionInfoMap aim) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SignedElements");
        if (ais.size() > 0) {
            return true;
        }
        ais = this.getAllAssertionsByLocalname(aim, "EncryptedElements");
        if (ais.size() > 0) {
            return true;
        }
        ais = this.getAllAssertionsByLocalname(aim, "ContentEncryptedElements");
        return ais.size() > 0;
    }
}

