/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.WSS4JStaxOutInterceptor;
import org.apache.cxf.ws.security.wss4j.policyhandlers.StaxAsymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.StaxSymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.StaxTransportBindingHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.policy.model.AsymmetricBinding;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.apache.wss4j.policy.model.TransportBinding;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class PolicyBasedWSS4JStaxOutInterceptor
extends WSS4JStaxOutInterceptor {
    public static final PolicyBasedWSS4JStaxOutInterceptor INSTANCE = new PolicyBasedWSS4JStaxOutInterceptor();

    @Override
    public void handleMessage(SoapMessage msg) throws Fault {
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        boolean enableStax = MessageUtils.isTrue(msg.getContextualProperty("ws-security.enable.streaming"));
        if (aim != null && enableStax) {
            this.getProperties().clear();
            super.handleMessage(msg);
        }
    }

    @Override
    protected WSSSecurityProperties createSecurityProperties() {
        return new WSSSecurityProperties();
    }

    private void checkAsymmetricBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (signCrypto != null) {
            message.put("signaturePropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
    }

    private void checkTransportBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (signCrypto != null) {
            message.put("signaturePropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
    }

    private void checkSymmetricBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (this.isRequestor(message)) {
            Crypto crypto = encrCrypto;
            if (crypto == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("encryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = signCrypto) == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("signaturePropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        } else {
            Crypto crypto = signCrypto;
            if (crypto == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("encryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = encrCrypto) == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("signaturePropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        }
    }

    @Override
    protected void configureProperties(SoapMessage msg, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Collection<AssertionInfo> transAis;
        Collection<AssertionInfo> symAis;
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        Collection<AssertionInfo> asymAis = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
        if (!asymAis.isEmpty()) {
            this.checkAsymmetricBinding(aim, msg, securityProperties);
        }
        if (!(symAis = this.getAllAssertionsByLocalname(aim, "SymmetricBinding")).isEmpty()) {
            this.checkSymmetricBinding(aim, msg, securityProperties);
        }
        if (!(transAis = this.getAllAssertionsByLocalname(aim, "TransportBinding")).isEmpty()) {
            this.checkTransportBinding(aim, msg, securityProperties);
        }
        super.configureProperties(msg, outboundTokens, securityProperties);
        if (!transAis.isEmpty()) {
            TransportBinding binding = (TransportBinding)transAis.iterator().next().getAssertion();
            new StaxTransportBindingHandler(securityProperties, msg, binding, outboundTokens).handleBinding();
        } else if (!asymAis.isEmpty()) {
            AsymmetricBinding binding = (AsymmetricBinding)asymAis.iterator().next().getAssertion();
            new StaxAsymmetricBindingHandler(securityProperties, msg, binding, outboundTokens).handleBinding();
        } else if (!symAis.isEmpty()) {
            SymmetricBinding binding = (SymmetricBinding)symAis.iterator().next().getAssertion();
            new StaxSymmetricBindingHandler(securityProperties, msg, binding, outboundTokens).handleBinding();
        } else {
            new StaxTransportBindingHandler(securityProperties, msg, null, outboundTokens).handleBinding();
        }
    }
}

