/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.SecurityContextToken;
import org.w3c.dom.Element;

public class SecurityContextTokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SecurityContextToken");
        if (!ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, results);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results) {
        List sctResults = WSSecurityUtil.fetchAllActionResults(results, (int)1024);
        for (AssertionInfo ai : ais) {
            SecurityContextToken sctPolicy = (SecurityContextToken)ai.getAssertion();
            ai.setAsserted(true);
            this.assertPolicy(aim, SP12Constants.REQUIRE_EXTERNAL_URI_REFERENCE);
            this.assertPolicy(aim, SP12Constants.SC13_SECURITY_CONTEXT_TOKEN);
            this.assertPolicy(aim, SP11Constants.SC10_SECURITY_CONTEXT_TOKEN);
            if (!this.isTokenRequired((AbstractToken)sctPolicy, message) || !sctResults.isEmpty()) continue;
            ai.setNotAsserted("The received token does not match the token inclusion requirement");
        }
    }
}

