/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.corba.maven.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.corba.maven.plugins.WsdltoidlOption;
import org.apache.cxf.tools.corba.WSDLToIDL;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class WSDLToIDLPlugin
extends AbstractMojo {
    File outputDir;
    WsdltoidlOption[] wsdltoidlOptions;
    MavenProject project;
    boolean useCompileClasspath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        if (this.outputDir == null) {
            throw new MojoExecutionException("The outputDir must be specified");
        }
        if (this.project == null) {
            throw new MojoExecutionException("The project must be specified");
        }
        if (this.wsdltoidlOptions == null) {
            throw new MojoExecutionException("Please specify the wsdltoidl options");
        }
        this.outputDir.mkdirs();
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringBuilder buf = new StringBuilder();
        try {
            urlList.add(this.outputDir.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        buf.append(this.outputDir.getAbsolutePath());
        buf.append(File.pathSeparatorChar);
        List artifacts = this.useCompileClasspath ? this.project.getCompileArtifacts() : this.project.getTestArtifacts();
        for (Artifact a : CastUtils.cast((List)artifacts, Artifact.class)) {
            try {
                if (a.getFile() == null || !a.getFile().exists()) continue;
                urlList.add(a.getFile().toURI().toURL());
                buf.append(a.getFile().getAbsolutePath());
                buf.append(File.pathSeparatorChar);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ClassLoader origContext = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ClassLoaderUtils.getURLClassLoader(urlList, (ClassLoader)origContext);
        String newCp = buf.toString();
        HashMap<Object, Object> origProps = new HashMap<Object, Object>(System.getProperties());
        String cp = System.getProperty("java.class.path");
        try {
            Thread.currentThread().setContextClassLoader(loader);
            System.setProperty("java.class.path", newCp);
            for (int x = 0; x < this.wsdltoidlOptions.length; ++x) {
                boolean doWork;
                File file = new File(this.wsdltoidlOptions[x].getWSDL());
                File doneFile = new File(this.outputDir, "." + file.getName() + ".DONE");
                boolean bl = doWork = file.lastModified() > doneFile.lastModified();
                if (!doneFile.exists()) {
                    doWork = true;
                } else if (file.lastModified() > doneFile.lastModified()) {
                    doWork = true;
                }
                if (!doWork) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add("-d");
                list.add(this.outputDir.getAbsolutePath());
                if (this.wsdltoidlOptions[x].isCorbaEnabled()) {
                    list.add("-corba");
                }
                if (this.wsdltoidlOptions[x].isIdlEnabled()) {
                    list.add("-idl");
                }
                if (this.wsdltoidlOptions[x].getExtraargs() != null) {
                    list.addAll(this.wsdltoidlOptions[x].getExtraargs());
                }
                list.add(this.wsdltoidlOptions[x].getWSDL());
                try {
                    WSDLToIDL.run((String[])list.toArray(new String[0]));
                    doneFile.delete();
                    doneFile.createNewFile();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
        }
        finally {
            Bus bus = BusFactory.getDefaultBus((boolean)false);
            if (bus != null) {
                bus.shutdown(true);
            }
            Thread.currentThread().setContextClassLoader(origContext);
            if (cp != null) {
                System.setProperty("java.class.path", cp);
            }
            HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
            for (Object o : newProps.keySet()) {
                if (origProps.containsKey(o)) continue;
                System.clearProperty(o.toString());
            }
            System.getProperties().putAll((Map<?, ?>)origProps);
        }
    }
}

