/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.QuotedPrintableDecoderStream;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttachmentUtil {
    private static volatile int counter;
    private static final String ATT_UUID;

    private AttachmentUtil() {
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "http://cxf.apache.org/";
        String name = ATT_UUID + "-" + String.valueOf(++counter);
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (URISyntaxException e) {
                cid = ns;
            }
            catch (MalformedURLException e) {
                cid = ns;
            }
        }
        return URLEncoder.encode(name, "UTF-8") + "@" + URLEncoder.encode(cid, "UTF-8");
    }

    public static String getUniqueBoundaryValue(int part) {
        StringBuffer s = new StringBuffer();
        s.append("----=_Part_").append(part++).append("_").append(s.hashCode()).append('.').append(System.currentTimeMillis());
        return s.toString();
    }

    public static String getAttchmentPartHeader(Attachment att) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(HttpHeaderHelper.getHeaderKey((String)"Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        buffer.append("Content-ID: <" + att.getId() + ">\r\n\r\n");
        return buffer.toString();
    }

    public static Map<String, DataHandler> getDHMap(Collection<Attachment> attachments) {
        Map<Object, Object> dataHandlers = null;
        if (attachments != null) {
            if (attachments instanceof LazyAttachmentCollection) {
                dataHandlers = ((LazyAttachmentCollection)attachments).createDataHandlerMap();
            } else {
                dataHandlers = new LinkedHashMap();
                for (Attachment attachment : attachments) {
                    dataHandlers.put(attachment.getId(), attachment.getDataHandler());
                }
            }
        }
        return dataHandlers == null ? new LinkedHashMap() : dataHandlers;
    }

    public static Attachment createAttachment(InputStream stream, InternetHeaders headers) throws IOException {
        AttachmentDataSource source;
        String id = headers.getHeader("Content-ID", null);
        id = id != null && id.startsWith("<") ? id.substring(1, id.length() - 1) : "Content-ID: <root.message@cxf.apache.org";
        id = URLDecoder.decode(id.startsWith("cid:") ? id.substring(4) : id, "UTF-8");
        AttachmentImpl att = new AttachmentImpl(id);
        String ct = headers.getHeader("Content-Type", null);
        boolean quotedPrintable = false;
        Enumeration e = headers.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            if (header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) {
                if (header.getValue().equalsIgnoreCase("binary")) {
                    att.setXOP(true);
                } else if (header.getValue().equalsIgnoreCase("quoted-printable")) {
                    quotedPrintable = true;
                }
            }
            att.setHeader(header.getName(), header.getValue());
        }
        if (quotedPrintable) {
            source = new AttachmentDataSource(ct, new QuotedPrintableDecoderStream(stream));
            att.setDataHandler(new DataHandler((DataSource)source));
        } else {
            source = new AttachmentDataSource(ct, stream);
            att.setDataHandler(new DataHandler((DataSource)source));
        }
        return att;
    }

    public static boolean isTypeSupported(String contentType, List<String> types) {
        if (contentType == null) {
            return false;
        }
        for (String s : types) {
            if (contentType.indexOf(s) == -1) continue;
            return true;
        }
        return false;
    }

    static {
        ATT_UUID = UUID.randomUUID().toString();
    }
}

