/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFaultConverter
extends AbstractPhaseInterceptor<Message> {
    public static final String DISABLE_FAULT_MAPPING = "disable-fault-mapping";
    private static final Logger LOG = LogUtils.getLogger(ClientFaultConverter.class);

    public ClientFaultConverter() {
        super("unmarshal");
    }

    public ClientFaultConverter(String phase) {
        super(phase);
    }

    public void handleMessage(Message msg) {
        Fault fault = (Fault)((Object)msg.getContent(Exception.class));
        if (fault.getDetail() != null && !MessageUtils.getContextualBoolean((Message)msg, (String)DISABLE_FAULT_MAPPING, (boolean)false)) {
            this.processFaultDetail(fault, msg);
            this.setStackTrace(fault, msg);
        }
        FaultMode faultMode = FaultMode.UNCHECKED_APPLICATION_FAULT;
        Method m = (Method)msg.getExchange().get(Method.class);
        if (m != null) {
            Exception e = (Exception)msg.getContent(Exception.class);
            for (Class<?> cl : m.getExceptionTypes()) {
                if (!cl.isInstance(e)) continue;
                faultMode = FaultMode.CHECKED_APPLICATION_FAULT;
                break;
            }
        }
        msg.getExchange().put(FaultMode.class, (Object)faultMode);
    }

    protected void processFaultDetail(Fault fault, Message msg) {
        DataReader reader;
        Element exDetail = (Element)DOMUtils.getChild((Node)fault.getDetail(), (int)1);
        if (exDetail == null) {
            return;
        }
        QName qname = new QName(exDetail.getNamespaceURI(), exDetail.getLocalName());
        FaultInfo faultWanted = null;
        MessagePartInfo part = null;
        BindingOperationInfo boi = (BindingOperationInfo)msg.getExchange().get(BindingOperationInfo.class);
        if (boi == null) {
            return;
        }
        if (boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        for (FaultInfo faultInfo : boi.getOperationInfo().getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                if (!qname.equals(mpi.getConcreteName())) continue;
                faultWanted = faultInfo;
                part = mpi;
                break;
            }
            if (faultWanted == null) continue;
            break;
        }
        if (faultWanted == null) {
            for (FaultInfo faultInfo : boi.getOperationInfo().getFaults()) {
                for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                    if (!qname.getLocalPart().equals(mpi.getConcreteName().getLocalPart())) continue;
                    faultWanted = faultInfo;
                    part = mpi;
                    break;
                }
                if (faultWanted == null) continue;
                break;
            }
        }
        if (faultWanted == null) {
            return;
        }
        Service s = (Service)msg.getExchange().get(Service.class);
        DataBinding dataBinding = s.getDataBinding();
        Object e = null;
        if (this.isDOMSupported(dataBinding)) {
            reader = dataBinding.createReader(Node.class);
            reader.setProperty(DataReader.FAULT, (Object)fault);
            e = reader.read(part, (Object)exDetail);
        } else {
            reader = dataBinding.createReader(XMLStreamReader.class);
            W3CDOMStreamReader xsr = new W3CDOMStreamReader(exDetail);
            try {
                xsr.nextTag();
            }
            catch (XMLStreamException e1) {
                throw new Fault((Throwable)e1);
            }
            reader.setProperty(DataReader.FAULT, (Object)fault);
            e = reader.read(part, (Object)xsr);
        }
        if (!(e instanceof Exception)) {
            try {
                Constructor constructor;
                Class exClass = (Class)faultWanted.getProperty(Class.class.getName(), Class.class);
                if (e == null) {
                    constructor = exClass.getConstructor(String.class);
                    e = constructor.newInstance(fault.getMessage());
                } else {
                    try {
                        constructor = this.getConstructor(exClass, e);
                        e = constructor.newInstance(fault.getMessage(), e);
                    }
                    catch (NoSuchMethodException e1) {
                        e = this.convertFaultBean(exClass, e, fault);
                    }
                }
                msg.setContent(Exception.class, e);
            }
            catch (Exception e1) {
                LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"EXCEPTION_WHILE_CREATING_EXCEPTION", (Throwable)e1, (Object)e1.getMessage());
            }
        } else if (e != null) {
            if (fault.getMessage() != null) {
                try {
                    Field f = Throwable.class.getDeclaredField("detailMessage");
                    f.setAccessible(true);
                    f.set(e, fault.getMessage());
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            msg.setContent(Exception.class, e);
        }
    }

    private Constructor getConstructor(Class<?> faultClass, Object e) throws NoSuchMethodException {
        Constructor<?>[] cons;
        Class<?> beanClass = e.getClass();
        for (Constructor<?> c : cons = faultClass.getConstructors()) {
            if (c.getParameterTypes().length != 2 || !String.class.equals(c.getParameterTypes()[0]) || !c.getParameterTypes()[1].isInstance(e)) continue;
            return c;
        }
        try {
            return faultClass.getConstructor(String.class, beanClass);
        }
        catch (NoSuchMethodException ex) {
            Class<?> cls = this.getPrimitiveClass(beanClass);
            if (cls != null) {
                return faultClass.getConstructor(String.class, cls);
            }
            throw ex;
        }
    }

    private boolean isDOMSupported(DataBinding db) {
        boolean supportsDOM = false;
        for (Class c : db.getSupportedReaderFormats()) {
            if (!c.equals(Node.class)) continue;
            supportsDOM = true;
        }
        return supportsDOM;
    }

    private void setStackTrace(Fault fault, Message msg) {
        HashMap ns = new HashMap();
        XPathUtils xu = new XPathUtils(ns);
        String ss = (String)xu.getValue("/stackTrace/text()", (Node)fault.getDetail(), XPathConstants.STRING);
        ArrayList<StackTraceElement> stackTraceList = new ArrayList<StackTraceElement>();
        if (!StringUtils.isEmpty((String)ss)) {
            StringTokenizer st = new StringTokenizer(ss, "\n");
            while (st.hasMoreTokens()) {
                String oneLine = st.nextToken();
                StringTokenizer stInner = new StringTokenizer(oneLine, "!");
                StackTraceElement ste = new StackTraceElement(stInner.nextToken(), stInner.nextToken(), stInner.nextToken(), Integer.parseInt(stInner.nextToken()));
                stackTraceList.add(ste);
            }
            if (stackTraceList.size() > 0) {
                StackTraceElement[] stackTraceElement = new StackTraceElement[stackTraceList.size()];
                Exception e = (Exception)msg.getContent(Exception.class);
                e.setStackTrace(stackTraceList.toArray(stackTraceElement));
            }
        }
    }

    private Class<?> getPrimitiveClass(Class<?> cls) {
        if (cls.isPrimitive()) {
            return cls;
        }
        try {
            Field field = cls.getField("TYPE");
            Class<?> obj = cls;
            Object type = field.get(obj);
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Exception convertFaultBean(Class<?> exClass, Object faultBean, Fault fault) throws Exception {
        Method[] meth;
        Constructor<?> constructor = exClass.getConstructor(String.class);
        Exception e = (Exception)constructor.newInstance(fault.getMessage());
        Class<?> obj = exClass;
        while (!obj.equals(Object.class)) {
            Field[] fields;
            for (Field f : fields = obj.getDeclaredFields()) {
                try {
                    Field beanField = faultBean.getClass().getDeclaredField(f.getName());
                    beanField.setAccessible(true);
                    f.setAccessible(true);
                    f.set(e, beanField.get(faultBean));
                }
                catch (NoSuchFieldException e1) {
                    // empty catch block
                }
            }
            obj = obj.getSuperclass();
        }
        for (Method m : meth = faultBean.getClass().getMethods()) {
            if (m.getParameterTypes().length != 0 || !m.getName().startsWith("get") && !m.getName().startsWith("is")) continue;
            try {
                String name = m.getName().startsWith("get") ? "set" + m.getName().substring(3) : "set" + m.getName().substring(2);
                Method m2 = exClass.getMethod(name, m.getReturnType());
                m2.invoke((Object)e, m.invoke(faultBean, new Object[0]));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return e;
    }
}

