/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature.transform;

import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractXSLTInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TransformerFactory TRANSFORM_FACTORIY = TransformerFactory.newInstance();
    private String contextPropertyName;
    private final Templates xsltTemplate;

    public AbstractXSLTInterceptor(String phase, Class<?> before, Class<?> after, String xsltPath) {
        super(phase);
        if (before != null) {
            this.addBefore(before.getName());
        }
        if (after != null) {
            this.addAfter(after.getName());
        }
        try {
            InputStream xsltStream = ClassLoaderUtils.getResourceAsStream((String)xsltPath, ((Object)((Object)this)).getClass());
            if (xsltStream == null) {
                throw new IllegalArgumentException("Cannot load XSLT from path: " + xsltPath);
            }
            StreamSource xsltSource = new StreamSource(xsltStream);
            this.xsltTemplate = TRANSFORM_FACTORIY.newTemplates(xsltSource);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException(String.format("Cannot create XSLT template from path: %s, error: ", xsltPath, e.getException()), e);
        }
    }

    public void setContextPropertyName(String propertyName) {
        this.contextPropertyName = propertyName;
    }

    protected boolean checkContextProperty(Message message) {
        return this.contextPropertyName != null && !MessageUtils.getContextualBoolean((Message)message, (String)this.contextPropertyName, (boolean)false);
    }

    protected Templates getXSLTTemplate() {
        return this.xsltTemplate;
    }
}

