/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.collection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapType
extends AegisType {
    private AegisType keyType;
    private AegisType valueType;
    private QName keyName;
    private QName valueName;
    private QName entryName;

    public MapType(QName schemaType, AegisType keyType, AegisType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.setSchemaType(schemaType);
        this.keyName = new QName(schemaType.getNamespaceURI(), "key");
        this.valueName = new QName(schemaType.getNamespaceURI(), "value");
        this.entryName = new QName(schemaType.getNamespaceURI(), "entry");
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        Map<Object, Object> map = this.instantiateMap();
        try {
            while (reader.hasMoreElementReaders()) {
                MessageReader entryReader = reader.getNextElementReader();
                if (entryReader.getName().equals(this.getEntryName())) {
                    Object key = null;
                    Object value = null;
                    while (entryReader.hasMoreElementReaders()) {
                        MessageReader evReader = entryReader.getNextElementReader();
                        if (evReader.getName().equals(this.getKeyName())) {
                            AegisType kType = TypeUtil.getReadType(evReader.getXMLStreamReader(), context.getGlobalContext(), this.getKeyType());
                            key = kType.readObject(evReader, context);
                            continue;
                        }
                        if (evReader.getName().equals(this.getValueName())) {
                            AegisType vType = TypeUtil.getReadType(evReader.getXMLStreamReader(), context.getGlobalContext(), this.getValueType());
                            value = vType.readObject(evReader, context);
                            continue;
                        }
                        this.readToEnd(evReader);
                    }
                    map.put(key, value);
                    continue;
                }
                this.readToEnd(entryReader);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected Map<Object, Object> instantiateMap() {
        Map<Object, Object> map = null;
        if (this.getTypeClass().equals(Map.class)) {
            map = new HashMap<Object, Object>();
        } else if (this.getTypeClass().equals(Hashtable.class)) {
            map = new Hashtable();
        } else if (this.getTypeClass().isInterface()) {
            map = new HashMap();
        } else {
            try {
                map = (Map)this.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new DatabindingException("Could not create map implementation: " + this.getTypeClass().getName(), (Throwable)e);
            }
        }
        return map;
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        if (object == null) {
            return;
        }
        try {
            Map map = (Map)object;
            AegisType kType = this.getKeyType();
            AegisType vType = this.getValueType();
            for (Map.Entry entry : map.entrySet()) {
                this.writeEntry(writer, context, kType, vType, entry);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    private void writeEntry(MessageWriter writer, Context context, AegisType kType, AegisType vType, Map.Entry entry) throws DatabindingException {
        kType = TypeUtil.getWriteType(context.getGlobalContext(), entry.getKey(), kType);
        vType = TypeUtil.getWriteType(context.getGlobalContext(), entry.getValue(), vType);
        MessageWriter entryWriter = writer.getElementWriter(this.getEntryName());
        MessageWriter keyWriter = entryWriter.getElementWriter(this.getKeyName());
        kType.writeObject(entry.getKey(), keyWriter, context);
        keyWriter.close();
        if (entry.getValue() != null) {
            MessageWriter valueWriter = entryWriter.getElementWriter(this.getValueName());
            vType.writeObject(entry.getValue(), valueWriter, context);
            valueWriter.close();
        }
        entryWriter.close();
    }

    @Override
    public void writeSchema(XmlSchema root) {
        XmlSchemaComplexType complex = new XmlSchemaComplexType(root, true);
        complex.setName(this.getSchemaType().getLocalPart());
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        complex.setParticle((XmlSchemaParticle)sequence);
        AegisType kType = this.getKeyType();
        AegisType vType = this.getValueType();
        XmlSchemaElement element = new XmlSchemaElement(root, false);
        sequence.getItems().add(element);
        element.setName(this.getEntryName().getLocalPart());
        element.setMinOccurs(0L);
        element.setMaxOccurs(Long.MAX_VALUE);
        XmlSchemaComplexType evType = new XmlSchemaComplexType(root, false);
        element.setType((XmlSchemaType)evType);
        XmlSchemaSequence evSequence = new XmlSchemaSequence();
        evType.setParticle((XmlSchemaParticle)evSequence);
        this.createElement(root, evSequence, this.getKeyName(), kType, false);
        this.createElement(root, evSequence, this.getValueName(), vType, true);
    }

    private void createElement(XmlSchema schema, XmlSchemaSequence seq, QName name, AegisType type, boolean optional) {
        XmlSchemaElement element = new XmlSchemaElement(schema, false);
        seq.getItems().add(element);
        element.setName(name.getLocalPart());
        element.setSchemaTypeName(type.getSchemaType());
        if (optional) {
            element.setMinOccurs(0L);
        } else {
            element.setMinOccurs(1L);
        }
        element.setMaxOccurs(1L);
    }

    @Override
    public Set<AegisType> getDependencies() {
        HashSet<AegisType> deps = new HashSet<AegisType>();
        deps.add(this.getKeyType());
        deps.add(this.getValueType());
        return deps;
    }

    public AegisType getKeyType() {
        return this.keyType;
    }

    public AegisType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public QName getKeyName() {
        return this.keyName;
    }

    public void setKeyName(QName keyName) {
        this.keyName = keyName;
    }

    public QName getValueName() {
        return this.valueName;
    }

    public void setValueName(QName valueName) {
        this.valueName = valueName;
    }

    public QName getEntryName() {
        return this.entryName;
    }

    public void setEntryName(QName entryName) {
        this.entryName = entryName;
    }
}

