/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint.dynamic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.EndpointImplFactory;
import org.apache.cxf.endpoint.SimpleEndpointImplFactory;
import org.apache.cxf.endpoint.dynamic.TypeClassInitializer;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClientFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(DynamicClientFactory.class);
    private Bus bus;
    private String tmpdir = System.getProperty("java.io.tmpdir");
    private boolean simpleBindingEnabled = true;
    private Map<String, Object> jaxbContextProperties;

    protected DynamicClientFactory(Bus bus) {
        this.bus = bus;
    }

    protected EndpointImplFactory getEndpointImplFactory() {
        return SimpleEndpointImplFactory.getSingleton();
    }

    public void setTemporaryDirectory(String dir) {
        this.tmpdir = dir;
    }

    public static DynamicClientFactory newInstance(Bus b) {
        return new DynamicClientFactory(b);
    }

    public static DynamicClientFactory newInstance() {
        Bus bus = CXFBusFactory.getThreadDefaultBus();
        return new DynamicClientFactory(bus);
    }

    public Client createClient(String wsdlUrl) {
        return this.createClient(wsdlUrl, (QName)null, (QName)null);
    }

    public Client createClient(String wsdlUrl, List<String> bindingFiles) {
        return this.createClient(wsdlUrl, (QName)null, (QName)null, bindingFiles);
    }

    public Client createClient(URL wsdlUrl) {
        return this.createClient(wsdlUrl, (QName)null, (QName)null);
    }

    public Client createClient(URL wsdlUrl, List<String> bindingFiles) {
        return this.createClient(wsdlUrl, (QName)null, (QName)null, bindingFiles);
    }

    public Client createClient(String wsdlUrl, ClassLoader classLoader) {
        return this.createClient(wsdlUrl, null, classLoader, null);
    }

    public Client createClient(String wsdlUrl, ClassLoader classLoader, List<String> bindingFiles) {
        return this.createClient(wsdlUrl, null, classLoader, null, bindingFiles);
    }

    public Client createClient(String wsdlUrl, QName service) {
        return this.createClient(wsdlUrl, service, (QName)null);
    }

    public Client createClient(String wsdlUrl, QName service, List<String> bindingFiles) {
        return this.createClient(wsdlUrl, service, null, bindingFiles);
    }

    public Client createClient(String wsdlUrl, QName service, QName port) {
        return this.createClient(wsdlUrl, service, null, port);
    }

    public Client createClient(String wsdlUrl, QName service, QName port, List<String> bindingFiles) {
        return this.createClient(wsdlUrl, service, null, port, bindingFiles);
    }

    public Client createClient(String wsdlUrl, QName service, ClassLoader classLoader, QName port) {
        return this.createClient(wsdlUrl, service, classLoader, port, null);
    }

    public Client createClient(URL wsdlUrl, ClassLoader classLoader) {
        return this.createClient(wsdlUrl, null, classLoader, null);
    }

    public Client createClient(URL wsdlUrl, ClassLoader classLoader, List<String> bindingFiles) {
        return this.createClient(wsdlUrl.toString(), null, classLoader, null, bindingFiles);
    }

    public Client createClient(URL wsdlUrl, QName service) {
        return this.createClient(wsdlUrl, service, (QName)null);
    }

    public Client createClient(URL wsdlUrl, QName service, List<String> bindingFiles) {
        return this.createClient(wsdlUrl, service, null, bindingFiles);
    }

    public Client createClient(URL wsdlUrl, QName service, QName port) {
        return this.createClient(wsdlUrl, service, null, port);
    }

    public Client createClient(URL wsdlUrl, QName service, QName port, List<String> bindingFiles) {
        return this.createClient(wsdlUrl.toString(), service, null, port, bindingFiles);
    }

    public Client createClient(URL wsdlUrl, QName service, ClassLoader classLoader, QName port) {
        return this.createClient(wsdlUrl.toString(), service, classLoader, port, null);
    }

    public Client createClient(URL wsdlUrl, QName service, ClassLoader classLoader, QName port, List<String> bindingFiles) {
        return this.createClient(wsdlUrl.toString(), service, classLoader, port, bindingFiles);
    }

    public Client createClient(String wsdlUrl, QName service, ClassLoader classLoader, QName port, List<String> bindingFiles) {
        JAXBContext context;
        URLClassLoader cl;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        URL u = this.composeUrl(wsdlUrl);
        LOG.log(Level.FINE, "Creating client from URL " + u.toString());
        ClientImpl client = new ClientImpl(this.bus, u, service, port, this.getEndpointImplFactory());
        Service svc = client.getEndpoint().getService();
        List schemas = ((ServiceInfo)svc.getServiceInfos().get(0)).getSchemas();
        JAXBUtils.SchemaCompiler compiler = JAXBUtils.createSchemaCompilerWithDefaultAllocator(new HashSet());
        Object elForRun = ReflectionInvokationHandler.createProxyWrapper((Object)new InnerErrorListener(wsdlUrl), (Class)JAXBUtils.getParamClass((JAXBUtils.SchemaCompiler)compiler, (String)"setErrorListener"));
        compiler.setErrorListener(elForRun);
        this.addSchemas(wsdlUrl, schemas, compiler);
        this.addBindingFiles(bindingFiles, compiler);
        JAXBUtils.S2JJAXBModel intermediateModel = compiler.bind();
        JAXBUtils.JCodeModel codeModel = intermediateModel.generateCode(null, elForRun);
        StringBuilder sb = new StringBuilder();
        boolean firstnt = false;
        Iterator packages = codeModel.packages();
        while (packages.hasNext()) {
            JAXBUtils.JPackage jpackage = (JAXBUtils.JPackage)packages.next();
            if (!this.isValidPackage(jpackage)) continue;
            if (firstnt) {
                sb.append(':');
            } else {
                firstnt = true;
            }
            sb.append(jpackage.name());
        }
        JAXBUtils.logGeneratedClassNames((Logger)LOG, (JAXBUtils.JCodeModel)codeModel);
        String packageList = sb.toString();
        String stem = this.toString() + "-" + System.currentTimeMillis();
        File src = new File(this.tmpdir, stem + "-src");
        if (!src.mkdir()) {
            throw new IllegalStateException("Unable to create working directory " + src.getPath());
        }
        try {
            Object writer = JAXBUtils.createFileCodeWriter((File)src);
            codeModel.build(writer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to write generated Java files for schemas: " + e.getMessage(), e);
        }
        File classes = new File(this.tmpdir, stem + "-classes");
        if (!classes.mkdir()) {
            throw new IllegalStateException("Unable to create working directory " + classes.getPath());
        }
        StringBuilder classPath = new StringBuilder();
        try {
            DynamicClientFactory.setupClasspath(classPath, classLoader);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        List srcFiles = FileUtils.getFilesRecurse((File)src, (String)".+\\.java$");
        if (!this.compileJavaSrc(classPath.toString(), srcFiles, classes.toString())) {
            LOG.log(Level.SEVERE, new Message("COULD_NOT_COMPILE_SRC", LOG, new Object[]{wsdlUrl}).toString());
        }
        FileUtils.removeDir((File)src);
        try {
            cl = new URLClassLoader(new URL[]{classes.toURI().toURL()}, classLoader);
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Internal error; a directory returns a malformed URL: " + mue.getMessage(), mue);
        }
        Map<String, Object> contextProperties = this.jaxbContextProperties;
        if (contextProperties == null) {
            contextProperties = Collections.emptyMap();
        }
        try {
            context = StringUtils.isEmpty((String)packageList) ? JAXBContext.newInstance((Class[])new Class[0], contextProperties) : JAXBContext.newInstance((String)packageList, (ClassLoader)cl, contextProperties);
        }
        catch (JAXBException jbe) {
            throw new IllegalStateException("Unable to create JAXBContext for generated packages: " + jbe.getMessage(), jbe);
        }
        JAXBDataBinding databinding = new JAXBDataBinding();
        databinding.setContext(context);
        svc.setDataBinding((DataBinding)databinding);
        ServiceInfo svcfo = client.getEndpoint().getEndpointInfo().getService();
        Thread.currentThread().setContextClassLoader(cl);
        TypeClassInitializer visitor = new TypeClassInitializer(svcfo, intermediateModel, this.allowWrapperOps());
        visitor.walk();
        FileUtils.removeDir((File)classes);
        return client;
    }

    protected boolean allowWrapperOps() {
        return false;
    }

    private void addBindingFiles(List<String> bindingFiles, JAXBUtils.SchemaCompiler compiler) {
        if (bindingFiles != null) {
            for (String s : bindingFiles) {
                URL url = this.composeUrl(s);
                try {
                    InputStream ins = url.openStream();
                    InputSource is = new InputSource(ins);
                    is.setSystemId(url.toString());
                    is.setPublicId(url.toString());
                    compiler.getOptions().addBindFile(is);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean isValidPackage(JAXBUtils.JPackage jpackage) {
        if (jpackage == null) {
            return false;
        }
        String name = jpackage.name();
        if ("org.w3._2001.xmlschema".equals(name) || "java.lang".equals(name) || "java.io".equals(name) || "generated".equals(name)) {
            return false;
        }
        Iterator i = jpackage.classes();
        while (i.hasNext()) {
            JAXBUtils.JDefinedClass current = (JAXBUtils.JDefinedClass)i.next();
            if (!"ObjectFactory".equals(current.name())) continue;
            return true;
        }
        return false;
    }

    private void addSchemas(String wsdlUrl, Collection<SchemaInfo> schemas, JAXBUtils.SchemaCompiler compiler) {
        int num = 1;
        for (SchemaInfo schema : schemas) {
            Element el = schema.getElement();
            String key = schema.getSystemId();
            if (StringUtils.isEmpty((String)key)) {
                key = wsdlUrl + "#types" + num;
            }
            InputSource is = new InputSource((InputStream)null);
            is.setSystemId(key);
            is.setPublicId(key);
            compiler.getOptions().addGrammar(is);
            compiler.parseSchema(key, el);
            ++num;
        }
        if (this.simpleBindingEnabled) {
            String id = "/org/apache/cxf/endpoint/dynamic/simple-binding.xjb";
            LOG.fine("Loading the JAXB 2.1 simple binding for client.");
            try {
                Document doc = StaxUtils.read((InputStream)this.getClass().getResourceAsStream(id));
                compiler.parseSchema(id, doc.getDocumentElement());
            }
            catch (XMLStreamException e) {
                LOG.log(Level.WARNING, "Could not parse simple-binding.xsd", e);
            }
        }
    }

    public boolean isSimpleBindingEnabled() {
        return this.simpleBindingEnabled;
    }

    public void setSimpleBindingEnabled(boolean simpleBindingEnabled) {
        this.simpleBindingEnabled = simpleBindingEnabled;
    }

    protected boolean compileJavaSrc(String classPath, List<File> srcList, String dest) {
        String[] javacCommand = new String[srcList.size() + 7];
        javacCommand[0] = "javac";
        javacCommand[1] = "-classpath";
        javacCommand[2] = classPath;
        javacCommand[3] = "-d";
        javacCommand[4] = dest;
        javacCommand[5] = "-target";
        javacCommand[6] = "1.5";
        int i = 7;
        for (File f : srcList) {
            javacCommand[i++] = f.getAbsolutePath();
        }
        Compiler javaCompiler = new Compiler();
        return javaCompiler.internalCompile(javacCommand, 7);
    }

    static void addClasspathFromManifest(StringBuilder classPath, File file) throws URISyntaxException, IOException {
        JarFile jar = new JarFile(file);
        Attributes attr = null;
        if (jar.getManifest() != null) {
            attr = jar.getManifest().getMainAttributes();
        }
        if (attr != null) {
            String cp = attr.getValue("Class-Path");
            while (cp != null) {
                URI uri;
                File f2;
                String fileName = cp;
                int idx = fileName.indexOf(32);
                if (idx != -1) {
                    fileName = fileName.substring(0, idx);
                    cp = cp.substring(idx + 1).trim();
                } else {
                    cp = null;
                }
                if (!(f2 = (uri = new URI(fileName)).isAbsolute() ? new File(uri) : new File(file, fileName)).exists()) continue;
                classPath.append(f2.getAbsolutePath());
                classPath.append(System.getProperty("path.separator"));
            }
        }
    }

    static void setupClasspath(StringBuilder classPath, ClassLoader classLoader) throws URISyntaxException, IOException {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ClassLoader tcl = classLoader;
        do {
            if (tcl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)tcl).getURLs();
                if (urls == null) {
                    urls = new URL[]{};
                }
                for (URL url : urls) {
                    File file;
                    if (!url.getProtocol().startsWith("file")) continue;
                    try {
                        URI uri = new URI(url.getProtocol(), null, url.getPath(), null, null);
                        if (uri.getPath() == null) continue;
                        file = new File(uri.getPath());
                    }
                    catch (URISyntaxException urise) {
                        if (url.getPath() == null) continue;
                        file = new File(url.getPath());
                    }
                    if (!file.exists()) continue;
                    classPath.append(file.getAbsolutePath()).append(System.getProperty("path.separator"));
                    if (!file.getName().endsWith(".jar")) continue;
                    DynamicClientFactory.addClasspathFromManifest(classPath, file);
                }
                continue;
            }
            if (!tcl.getClass().getName().contains("weblogic")) continue;
            try {
                Method method = tcl.getClass().getMethod("getClassPath", new Class[0]);
                Object weblogicClassPath = method.invoke((Object)tcl, new Object[0]);
                classPath.append(weblogicClassPath).append(System.getProperty("path.separator"));
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "unsuccessfully tried getClassPath method", e);
            }
        } while (null != (tcl = tcl.getParent()) && !tcl.equals(scl.getParent()));
    }

    private URL composeUrl(String s) {
        try {
            URIResolver resolver = new URIResolver(null, s, this.getClass());
            if (resolver.isResolved()) {
                return resolver.getURI().toURL();
            }
            throw new ServiceConstructionException(new Message("COULD_NOT_RESOLVE_URL", LOG, new Object[]{s}));
        }
        catch (IOException e) {
            throw new ServiceConstructionException(new Message("COULD_NOT_RESOLVE_URL", LOG, new Object[]{s}), (Throwable)e);
        }
    }

    public Map<String, Object> getJaxbContextProperties() {
        return this.jaxbContextProperties;
    }

    public void setJaxbContextProperties(Map<String, Object> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    static class RelativeEntityResolver
    implements EntityResolver {
        private String baseURI;

        public RelativeEntityResolver(String baseURI) {
            this.baseURI = baseURI;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null) {
                File file = new File(this.baseURI, systemId);
                if (file.exists()) {
                    return new InputSource(new FileInputStream(file));
                }
                return new InputSource(systemId);
            }
            return null;
        }
    }

    class InnerErrorListener {
        private String url;

        InnerErrorListener(String url) {
            this.url = url;
        }

        public void error(SAXParseException arg0) {
            throw new RuntimeException("Error compiling schema from WSDL at {" + this.url + "}: " + arg0.getMessage(), arg0);
        }

        public void fatalError(SAXParseException arg0) {
            throw new RuntimeException("Fatal error compiling schema from WSDL at {" + this.url + "}: " + arg0.getMessage(), arg0);
        }

        public void info(SAXParseException arg0) {
        }

        public void warning(SAXParseException arg0) {
        }
    }
}

