/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.UrlUtilities;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final WSDLGetInterceptor INSTANCE = new WSDLGetInterceptor();
    public static final String AUTO_REWRITE_ADDRESS = "autoRewriteSoapAddress";
    public static final String PUBLISHED_ENDPOINT_URL = "publishedEndpointUrl";
    private static final String WSDLS_KEY = WSDLGetInterceptor.class.getName() + ".WSDLs";
    private static final String SCHEMAS_KEY = WSDLGetInterceptor.class.getName() + ".Schemas";
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLGetInterceptor.class);

    public WSDLGetInterceptor() {
        super("read");
        this.getAfter().add(EndpointSelectionInterceptor.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty((String)query)) {
            return;
        }
        String baseUri = (String)message.get((Object)"org.apache.cxf.request.url");
        String ctx = (String)message.get((Object)Message.PATH_INFO);
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            Map map = UrlUtilities.parseQueryString((String)query);
            if (this.isRecognizedQuery(map, baseUri, ctx, message.getExchange().getEndpoint().getEndpointInfo())) {
                try {
                    Conduit c = message.getExchange().getDestination().getBackChannel(message, null, null);
                    MessageImpl mout = new MessageImpl();
                    mout.setExchange(message.getExchange());
                    message.getExchange().setOutMessage((Message)mout);
                    mout.put((Object)"Content-Type", (Object)"text/xml");
                    c.prepare((Message)mout);
                    OutputStream os = (OutputStream)mout.getContent(OutputStream.class);
                    this.writeResponse(message, baseUri, map, ctx, message.getExchange().getEndpoint().getEndpointInfo(), os);
                    message.getInterceptorChain().abort();
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Failure writing full wsdl to the stream", ex);
                    }
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
                finally {
                    message.getExchange().setOutMessage(null);
                }
            }
        }
    }

    public boolean isRecognizedQuery(Map<String, String> map, String baseUri, String ctx, EndpointInfo endpointInfo) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo, OutputStream os) {
        try {
            Document doc;
            String xsd;
            String wsdl;
            Bus bus = message.getExchange().getBus();
            Object prop = message.getContextualProperty(PUBLISHED_ENDPOINT_URL);
            if (prop != null) {
                base = String.valueOf(prop);
            }
            if ((wsdl = params.get("wsdl")) != null) {
                wsdl = URLDecoder.decode(wsdl, "utf-8");
            }
            if ((xsd = params.get("xsd")) != null) {
                xsd = URLDecoder.decode(xsd, "utf-8");
            }
            Map mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLS_KEY)));
            Map smp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY)));
            if (mp == null) {
                endpointInfo.getService().setProperty(WSDLS_KEY, new ConcurrentHashMap());
                mp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(WSDLS_KEY)));
            }
            if (smp == null) {
                endpointInfo.getService().setProperty(SCHEMAS_KEY, new ConcurrentHashMap());
                smp = CastUtils.cast((Map)((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY)));
            }
            if (!mp.containsKey("")) {
                Definition def = new ServiceWSDLBuilder(bus, new ServiceInfo[]{endpointInfo.getService()}).build();
                mp.put("", def);
                this.updateDefinition(bus, def, mp, smp, base, endpointInfo);
            }
            if (xsd == null) {
                Object wsdl2;
                Definition def = (Definition)mp.get(wsdl);
                if (def == null && (wsdl2 = WSDLGetInterceptor.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)bus), wsdl, base)) != null) {
                    def = (Definition)mp.get(wsdl2);
                }
                if (def == null) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("WSDL_NOT_FOUND", LOG, new Object[]{wsdl}), null);
                }
                wsdl2 = def;
                synchronized (wsdl2) {
                    if (endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL) != null) {
                        String epurl = String.valueOf(endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL));
                        this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
                        base = epurl;
                    }
                    WSDLWriter wsdlWriter = ((WSDLManager)bus.getExtension(WSDLManager.class)).getWSDLFactory().newWSDLWriter();
                    def.setExtensionRegistry(((WSDLManager)bus.getExtension(WSDLManager.class)).getExtensionRegistry());
                    doc = wsdlWriter.getDocument(def);
                }
            } else {
                String xsd2;
                SchemaReference si = (SchemaReference)smp.get(xsd);
                if (si == null && (xsd2 = WSDLGetInterceptor.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)bus), xsd, base)) != null) {
                    si = (SchemaReference)smp.get(xsd2);
                }
                if (si == null) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("SCHEMA_NOT_FOUND", LOG, new Object[]{wsdl}), null);
                }
                String uri = si.getReferencedSchema().getDocumentBaseURI();
                uri = WSDLGetInterceptor.resolveWithCatalogs(OASISCatalogManager.getCatalogManager((Bus)bus), uri, si.getReferencedSchema().getDocumentBaseURI());
                if (uri == null) {
                    uri = si.getReferencedSchema().getDocumentBaseURI();
                }
                ResourceManagerWSDLLocator rml = new ResourceManagerWSDLLocator(uri, bus);
                InputSource src = rml.getBaseInputSource();
                doc = XMLUtils.getParser().parse(src);
            }
            this.updateDoc(doc, base, mp, smp, message);
            String enc = null;
            try {
                enc = doc.getXmlEncoding();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (enc == null) {
                enc = "utf-8";
            }
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)os, (String)enc);
            StaxUtils.writeNode((Node)doc, (XMLStreamWriter)writer, (boolean)true);
            writer.flush();
        }
        catch (WSDLQueryException wex) {
            throw wex;
        }
        catch (Exception wex) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{base}), wex);
        }
    }

    protected void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp, Message message) {
        List elementList = null;
        Object rewriteSoapAddress = message.getContextualProperty(AUTO_REWRITE_ADDRESS);
        try {
            String sl;
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"import");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"include");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"redefine");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"import");
            for (Element el : elementList) {
                sl = el.getAttribute("location");
                if (!mp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("location", base + "?wsdl=" + sl.replace(" ", "%20"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{base}), e);
        }
        if (rewriteSoapAddress == null || MessageUtils.isTrue((Object)rewriteSoapAddress)) {
            List serviceList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"service");
            for (Element serviceEl : serviceList) {
                String serviceName = serviceEl.getAttribute("name");
                if (!serviceName.equals(message.getExchange().getService().getName().getLocalPart())) continue;
                elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
                for (Element el : elementList) {
                    String name = el.getAttribute("name");
                    if (!name.equals(message.getExchange().getEndpoint().getEndpointInfo().getName().getLocalPart())) continue;
                    this.rewriteAddress(base, el, "http://schemas.xmlsoap.org/wsdl/soap/");
                    this.rewriteAddress(base, el, "http://schemas.xmlsoap.org/wsdl/soap12/");
                }
            }
        }
        try {
            doc.setXmlStandalone(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void rewriteAddress(String base, Element el, String soapNS) {
        List sadEls = DOMUtils.findAllElementsByTagNameNS((Element)el, (String)soapNS, (String)"address");
        for (Element soapAddress : sadEls) {
            soapAddress.setAttribute("location", base);
        }
    }

    static String resolveWithCatalogs(OASISCatalogManager catalogs, String start, String base) {
        try {
            return new OASISCatalogManagerHelper().resolve(catalogs, start, base);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void updateDefinition(Bus bus, Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager((Bus)bus);
        Collection imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List impLst = CastUtils.cast((List)lst);
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
                }
                String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                        this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
                    }
                    continue;
                }
                if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                done.put(resolvedSchemaLocation, imp.getDefinition());
                this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : CastUtils.cast((List)types.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(bus, see, doneSchemas, base);
            }
        }
    }

    protected void updatePublishedEndpointUrl(String publishingUrl, Definition def, QName name) {
        Collection services = CastUtils.cast(def.getAllServices().values());
        for (Service service : services) {
            Collection ports = CastUtils.cast(service.getPorts().values());
            if (ports.isEmpty()) continue;
            if (name == null) {
                this.setSoapAddressLocationOn((Port)ports.iterator().next(), publishingUrl);
                break;
            }
            for (Port port : ports) {
                if (!name.getLocalPart().equals(port.getName())) continue;
                this.setSoapAddressLocationOn(port, publishingUrl);
            }
        }
    }

    private void setSoapAddressLocationOn(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAP12Address) {
                ((SOAP12Address)extension).setLocationURI(url);
                continue;
            }
            if (!(extension instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension).setLocationURI(url);
        }
    }

    protected void updateSchemaImports(Bus bus, Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager((Bus)bus);
        Collection imports = CastUtils.cast(schema.getImports().values());
        for (List lst : imports) {
            List impLst = CastUtils.cast((List)lst);
            for (SchemaImport imp : impLst) {
                String start = imp.getSchemaLocationURI();
                if (start == null) continue;
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
                }
                if (doneSchemas.containsKey(decodedStart)) continue;
                String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start);
                    }
                    catch (MalformedURLException e) {
                        if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                        this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
                    }
                    continue;
                }
                if (doneSchemas.put(decodedStart, (SchemaReference)imp) != null) continue;
                doneSchemas.put(resolvedSchemaLocation, (SchemaReference)imp);
                this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
            }
        }
        List includes = CastUtils.cast((List)schema.getIncludes());
        for (SchemaReference included : includes) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
            }
            String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
        List redefines = CastUtils.cast((List)schema.getRedefines());
        for (SchemaReference included : redefines) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, new Object[]{start}), e);
            }
            String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
    }
}

